# -*- mode:python; coding:utf-8; -*-

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

from __future__ import print_function
from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

from future import standard_library
standard_library.install_aliases()
from builtins import *

import sys
import signal


#############################################
# SIGTERM handler and checker
EXIT_NOW = False


def sigterm_handler(signum, frame):
    print('SIGTERM fired')
    global EXIT_NOW
    EXIT_NOW = True


def sigterm_check():
    if EXIT_NOW:
        sys.exit(1)


signal.signal(signal.SIGTERM, sigterm_handler)
# ./SIGTERM
##############################################
