#!/bin/bash

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

. /opt/alt/python37/usr/share/python-cllib/scripts/cl-common
common_path_of_cpanel="/usr/share/cagefs/cpanel"

if is_ea4; then
    writeToLog "[CageFS] EasyApache 4 is active. Skip rebuilding suexec and suphp" "$common_path_of_cpanel"
else

  if /usr/bin/cldetect --cpanel-suphp-enabled; then
      if ! grep lve_jail_uid /opt/suphp/sbin/suphp; then
          /usr/sbin/cpanel-compile-suphp.sh
      fi
  fi

  if [ -e /usr/local/apache/bin/suexec ]; then
      if ! grep lve_jail_uid /usr/local/apache/bin/suexec; then
          /usr/sbin/cpanel-compile-suexec.sh
          /etc/rc.d/init.d/httpd restart
      fi
  fi
fi

nohup /usr/bin/ionice -c 3 /usr/sbin/cagefsctl --force-update > /dev/null &

/usr/share/cagefs-plugins/install-cagefs-plugin.py --add-usr-local-easy-mount
/usr/share/cagefs-plugins/install-cagefs-plugin.py --setup-ea-php-sessions
if [ -e /usr/share/cagefs/need.remount ]; then
    /usr/sbin/cagefsctl --remount-all
fi

exit 0
