<?php
/**
 * Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
 *
 * Licensed under CLOUD LINUX LICENSE AGREEMENT
 * http://cloudlinux.com/docs/LICENSE.TXT
 */
require_once('modules/pm.php');
define ("CAGEFS_SKELETON", "/usr/share/cagefs-skeleton/bin");
define ("CAGEFS_RESULTFILE", "/var/log/cagefs-update.log");
define ("CAGEFS_RESULTFILEUPD", "/var/log/cagefs-update.log");

checkAdmin();

function checkAdmin() {
  $session = new pm_Session();
  $client = $session->getClient();
  if ( !$client->isAdmin() ) {
    die('INSUFFICIENT PRIVILEGES');
  }
}

function
checkForCageFSCtlExists ()
{
  ob_start ();
  passthru ("/usr/bin/sudo /bin/ps aux | /bin/grep cagefsctl");
  $psInfoTmp = ob_get_contents ();
  ob_end_clean ();
  $res = explode (PHP_EOL, $psInfoTmp);
  $result = array ("action"=>"none");
  for ($i = 0; $i < count ($res); $i++)
    {
      if (strstr ($res[$i], "--init") !== FALSE)
	{
	  $result["action"] = "init";
	}
      if (strstr ($res[$i], "--reinit") !== FALSE)
	{
	  $result["action"] = "init";
	}
      if (strstr ($res[$i], "--update") !== FALSE)
	{
	  $result["action"] = "update";
	}
    }
  return $result;
}

function
checkForSkeleteon ()
{
  if (file_exists (CAGEFS_SKELETON))
    {
      if (is_dir (CAGEFS_SKELETON))
	{
	  return true;
	}
    }
  return false;
}

function checkCagefsMode(){
	$command = "/usr/bin/sudo /usr/sbin/cagefsctl --display-user-mode";                                                                                  
        ob_start ();                                                                                                                                         
        passthru ($command);                                                                                                                                 
        $InfoTmp = ob_get_contents();                                                                                                                        
        ob_end_clean ();                                                                                                                                     
	$res = array("mode"=>"DISABLED", "submode"=>"");
        if(strstr($InfoTmp,"CageFS is disabled")!==FALSE){
		return $res;
	} else {
		if(strstr($InfoTmp,"Mode: Enable All")!==FALSE){
			$res["mode"]="ENABLED";
			$res["submode"]="Enable All";
		} else {
			$res["mode"]="ENABLED";
			$res["submode"]="Disable All";
		}
	}
	return $res;
}

function getCagefsEnabledList(){
	$command = "/usr/bin/sudo /usr/sbin/cagefsctl --list-enabled";                                                                                  
        ob_start ();                                                                                                                                         
        passthru ($command);                                                                                                                                 
        $InfoTmp = ob_get_contents();                                                                                                                        
        ob_end_clean ();
	$res = explode("\n",$InfoTmp);
	return $res;
}

function getCagefsDisabledList(){
	$command = "/usr/bin/sudo /usr/sbin/cagefsctl --list-disabled";                                                                                  
        ob_start ();                                                                                                                                         
        passthru ($command);                                                                                                                                 
        $InfoTmp = ob_get_contents();                                                                                                                        
        ob_end_clean ();
	$res = explode("\n",$InfoTmp);
	return $res;
}

function CheckKernel() {
	$command = "/usr/bin/sudo /usr/sbin/cagefsctl --check-kernel-version";                                                                                  
        ob_start ();                                                                                                                                         
        passthru ($command);                                                                                                                                 
        $InfoTmp = ob_get_contents();                                                                                                                        
        ob_end_clean ();
	if (strstr($InfoTmp,'supported')) {
            return false;
        } else 
            return true;
}