<?php
/**
 * Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
 *
 * Licensed under CLOUD LINUX LICENSE AGREEMENT
 * http://cloudlinux.com/docs/LICENSE.TXT
 */
require_once ('modules/plesk-cagefs/options.php');

class ManagePage
{
  private $module_pointer;

  public function _construct ($ptr)
  {
    $module_pointer = $ptr;
  }

  public function getResult ($vars)
  {
    $ovars = $vars;
    $ovars["CAGEFS_DATA"]="";
    
    if (checkForSkeleteon ()){                                                                  
	$check_cagefs_state = checkCagefsMode();
	if(isset($_POST["toggle_hid"])){
		if($check_cagefs_state["mode"]=="ENABLED"){
			$command = "/usr/bin/sudo /usr/sbin/cagefsctl --toggle-mode";                                                                                       
        		ob_start ();                                                                                                                                         
        		passthru ($command);                                                                                                                                 
        		ob_end_clean ();
			
		}
    	} else if (isset($_POST["disable_hid"])){
		if($check_cagefs_state["mode"]=="ENABLED"){
			$command = "/usr/bin/sudo /usr/sbin/cagefsctl --disable-cagefs";                                                                                       
        		ob_start ();                                                                                                                                         
        		passthru ($command);                                                                                                                                 
        		ob_end_clean ();
		}
    	} else if (isset($_POST["dis_user_list"])){
		if(($check_cagefs_state["mode"]=="ENABLED")&&(count($_POST["dis_user_list"])>0)){
			$us_list="";
			for($i=0;$i<count($_POST["dis_user_list"]);$i++){
				preg_match("/([\w\-_.]+)/", $_POST["dis_user_list"][$i], $captured);
				if ($captured[1]) {
					$us_list .= "\"".trim(str_replace("\"","\\\"",$captured[1]))."\" ";
					$captured = array();
				}
			}
			if(trim($us_list)!=""){
				$command = "/usr/bin/sudo /usr/sbin/cagefsctl --enable ".$us_list;
				ob_start ();
				passthru ($command);
				ob_end_clean ();
			} 
		}
    	} else if (isset($_POST["en_user_list"])){
		if(($check_cagefs_state["mode"]=="ENABLED")&&(count($_POST["en_user_list"])>0)){
			$us_list="";
			for($i=0;$i<count($_POST["en_user_list"]);$i++){
              preg_match("/([\w\-_.]+)/", $_POST["en_user_list"][$i], $captured);
              if ($captured[1]) {
					$us_list .= "\"".trim(str_replace("\"","\\\"",$captured[1]))."\" ";
					$captured = array();
              }
			}
			if(trim($us_list)!=""){
				$command = "/usr/bin/sudo /usr/sbin/cagefsctl --disable ".$us_list;
				ob_start ();
				passthru ($command);
				ob_end_clean ();
			}
		}
    	} else if (isset($_POST["enable_hid"])){
		if($check_cagefs_state["mode"]=="DISABLED"){
			$command = "/usr/bin/sudo /usr/sbin/cagefsctl --enable-cagefs";                                                                                       
        		ob_start ();                                                                                                                                         
        		passthru ($command);                                                                                                                                 
        		ob_end_clean ();
		}
    	}
	
	$check_cagefs_state = checkCagefsMode();
	if($check_cagefs_state["mode"]=="ENABLED"){
		$enabled = getCagefsEnabledList();
		$desabled = getCagefsDisabledList();
		$ovars["CAGEFS_DATA"].= "<div>".
					" <table cellspacing=\"0px\" cellpadding=\"10px\">".
					"  <tr>";
		if($check_cagefs_state["submode"]=="Enable All"){
			$ovars["CAGEFS_DATA"].="   <td>New users will be in CageFS by default (enable all)</td>";
		} else {
			$ovars["CAGEFS_DATA"].="   <td>New users will <b>not</b> be in CageFS by default (disable all)</td>";
		}
		$ovars["CAGEFS_DATA"].= "   <td>".
					"    <form id=\"form1\" name=\"form1\" method=\"post\" action=\"\">".
					"     <input type=\"button\" name=\"toggle\" id=\"toggle\" value=\"   Toggle   \"/>".
					"     <input type=\"hidden\" name=\"toggle_hid\" id=\"toggle_hid\" value=\"toggle\"/>".
					"    </form>".
					"   </td>".
					"  </tr>".
					" </table>".
					"</div>".
					"<br/>".
					"<br/>".
					"<div>".
					" <table cellspacing=\"0px\" cellpadding=\"10px\"> ".
					"  <tr>".
					"   <td>".
					"    <div>Disabled:</div>".
					"    <div><input type=\"text\" width=\"300px\" style=\"width: 290px\" name=\"dis_user\" id=\"dis_user\" value=\"\"></div>".
					"    <div><form id=\"form_dis\" name=\"form_dis\" method=\"post\" action=\"\">".
					"     <select name=\"dis_user_list[]\" id=\"dis_user_list\" size=\"10\" width=\"300px\" style=\"width: 300px; height: 200px;\" multiple>";
		for($i=1;$i<count($desabled);$i++){
			if(trim($desabled[$i])!=""){
				$ovars["CAGEFS_DATA"].="<option value=\"".$desabled[$i]."\">".$desabled[$i]."</option>";
			}
		}
		$ovars["CAGEFS_DATA"].=	"     </select></form>";
		$ovars["CAGEFS_DATA"].=	"     <select name=\"dis_user_list_hid\" id=\"dis_user_list_hid\" style=\"display:none;\">";
		for($i=1;$i<count($desabled);$i++){
			if(trim($desabled[$i])!=""){
				$ovars["CAGEFS_DATA"].="<option value=\"".$desabled[$i]."\">".$desabled[$i]."</option>";
			}
		}
		$ovars["CAGEFS_DATA"].=	"     </select>".
					"    </div>".
					"   </td>".
					"   <td>".
					"   <p>".
					"    <input type=\"button\" id=\"to_disabled\" value=\" << \"/>".
					"   </p>".
					"   <p>".
					"    <input type=\"button\" id=\"to_enabled\" value=\" >> \"/>".
					"   </p>".
					"   <p><img id=\"picture_loader\" src=\"/images/modules/plesk-cagefs/Linux_Cloud_Loader.gif\" style=\"display: none;\"/></p>".
					"   </td>".
					"   <td>".
					"    <div>Enabled:</div>".
					"    <div><input type=\"text\" width=\"300px\" style=\"width: 290px\" name=\"en_user\" id=\"en_user\" value=\"\"></div>".
					"    <div><form id=\"form_en\" name=\"form_en\" method=\"post\" action=\"\">".
					"     <select name=\"en_user_list[]\" id=\"en_user_list\" width=\"300px\" style=\"width: 300px; height: 200px;\" multiple>";
		for($i=1;$i<count($enabled);$i++){
			if(trim($enabled[$i])){
				$ovars["CAGEFS_DATA"].="<option value=\"".$enabled[$i]."\">".$enabled[$i]."</option>";
			}
		}
		$ovars["CAGEFS_DATA"].= "     </select></form>";
		$ovars["CAGEFS_DATA"].= "     <select name=\"en_user_list_hid\" id=\"en_user_list_hid\" style=\"display: none\">";
		for($i=1;$i<count($enabled);$i++){
			if(trim($enabled[$i])){
				$ovars["CAGEFS_DATA"].="<option value=\"".$enabled[$i]."\">".$enabled[$i]."</option>";
			}
		}
		$ovars["CAGEFS_DATA"].= "     </select>".
					"    </div>".
					"   </td>".
					"  </tr>";
		$ovars["CAGEFS_DATA"].= "  <tr>".
					"   <td align=\"left\">".                                                                                                           
                                        "    <form id=\"form3\" name=\"form3\" method=\"post\" action=\"\">".                                                
                                        "     <input type=\"button\" name=\"disable\" id=\"disable\" value=\"   Disable CageFS   \"/>".                      
                                        "     <input type=\"hidden\" name=\"disable_hid\" id=\"disable_hid\" value=\"disable\"/>".                           
                                        "    </form>".                                                                                                       
                                        "   </td>".   
					"   <td colspan=\"2\" align=\"right\">".                                                                                                           
                                        "    <form id=\"form3\" name=\"form4\" method=\"post\" action=\"\">".                                                
                                        "     <input type=\"button\" name=\"updateskel\" id=\"updateskel\" value=\"   Update CageFS Skeleton   \"/>".                      
                                        "     <input type=\"hidden\" name=\"updateskel_hid\" id=\"updateskel_hid\" value=\"updateskel\"/>".                           
                                        "    </form>".                                                                                                       
                                        "   </td>".
					"  </tr>".
					" </table>".
					" <br/>".
					" <form id=\"form2_t\" name=\"form2_t\" method=\"post\" action=\"\">".
					" </form>".
					"</div>";
			
	}else{
		$ovars["CAGEFS_DATA"].=	"<div>".
					" <table cellspacing=\"0px\" cellpadding=\"10px\">".
					"  <tr>".
					"   <td>".
					"    <form id=\"form3\" name=\"form3\" method=\"post\" action=\"\">".
					"     <input type=\"button\" name=\"enable\" id=\"enable\" value=\"   Enable CageFS   \"/>".
					"     <input type=\"hidden\" name=\"enable_hid\" id=\"enable_hid\" value=\"enable\"/>".
					"    </form>".
					"   </td>".
					"  </tr>".
					" </table>".
					"</div>";
	}
    } else {
	$ovars["CAGEFS_DATA"]="<p>Init cagefs skeleton at firts</p>";
    }
    return $ovars;
  }

}


