<?php
/**
 * Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
 *
 * Licensed under CLOUD LINUX LICENSE AGREEMENT
 * http://cloudlinux.com/docs/LICENSE.TXT
 */
require_once('modules/plesk-cagefs/protect.php');
require_once('modules/plesk-cagefs/options.php');
require_once('modules/plesk-cagefs/ModuleForm.php');

checkAdmin();

if ( CheckKernel() === false ) {
    echo "Kernel not supported. Please update kernel";
    exit();
}

if ( checkForSkeleteon() ) {
    $activeTab = get_gpc('tab', 'manage');
}
else {
    $activeTab = get_gpc('tab', 'init');
}

$action = get_gpc('action', '');
if ( $activeTab=='manage' ) {
    $isAction = checkForCageFSCtlExists();
    if ( $isAction["action"] == "update" ){
        header('Location: ?tab=update&'.PROTECT_URL);
        exit();
    }
    elseif ( ($isAction["action"] == "init") || ($isAction["action"] == "reinit") ) {
        header('Location: ?tab=init&'.PROTECT_URL);
        exit();
    }
}

// actions processing can be added here
$form = new ModuleForm();
$form->setActiveTab($activeTab);
$form->setAction($action); 
$form->define();
$form->assign();
$form->parse();
$form->FastPrint();
