<?php
/**
 * Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
 *
 * Licensed under CLOUD LINUX LICENSE AGREEMENT
 * http://cloudlinux.com/docs/LICENSE.TXT
 */
    /*
     * Title: CageFSManager Module.
     * Version: 1.0.1 (24/Jan/2012)
     * Author: Krishtopin Anton. AKrishtopin@cloudlinux.com
     * Site: http://CloudLinux.com
    */
    
class CageFSUsers {
    private $XML = array();
    
    public function __construct($XML = null) {
        $this->XML = @simplexml_load_string($XML);
    }
    
    public function PrintXml() {
        echo $this->XML->asXML();
    }
    
    private function CommandExecute($command,$result = true) {
        if ($result) {
            ob_start();
            passthru($command);
            $return = ob_get_contents();
            ob_end_clean();
            return explode(PHP_EOL,$return);
        } else {
            passthru($command);
            return true;
        }
    }
    
    private function GetCagefsEnabledList() {
        $result = CageFSUsers::CommandExecute('/usr/sbin/cagefsctl --list-enabled');
        unset($result[count($result)-1],$result[count($result)-1],$result[0]);
        asort($result);
        return $result;
    }

    private function GetCagefsDisabledList() {
        $result = CageFSUsers::CommandExecute('/usr/sbin/cagefsctl --list-disabled');
        unset($result[count($result)-1],$result[count($result)-1],$result[0]);
        asort($result);
        return $result;
    }
    
    private function ChangeUserMode($user, $mode) {
        $savemode = $mode == 'enable'?'enable':'disable';
        $result = CageFSUsers::CommandExecute('/usr/sbin/cagefsctl --'.$savemode.' '.$user,false);
        return true;
    }
    
    private function HookForSelector($user) {
    	touch("/usr/local/ispmgr/addon/cagefs/.postcreate.{$user}");
    }
    
    // Get all users for Users list
    public function GetCageUsers() {
        $Disabled = array();
        $Enabled = array();
        
        $temp = CageFSUsers::GetCagefsDisabledList();
        if (count($temp) != 0) {
            foreach ($temp as $item) {
                $Disabled[$item] = 1;
            }
        }
        
        $temp = CageFSUsers::GetCagefsEnabledList();
        if (count($temp) != 0) {
            foreach ($temp as $item) {
                $Enabled[$item] = 1;
            }
        }
        
        foreach ($this->XML->elem as $item) {
            if (array_key_exists((string)$item->name, $Enabled)) {
                $item->cagefs_status = 'Enabled';
            } else {
                $item->cagefs_status = 'Disabled';
            }
        }
    }
    
    // Get user status for User settings
    public function GetCagefsUser($request) {
        $user = explode('&',$request);
        $user = str_replace('elid=','',$user[1]);
        
        $Enabled = array();
        
        $temp = CageFSUsers::GetCagefsEnabledList();
        if (count($temp) != 0) {
            foreach ($temp as $item) {
                $Enabled[$item] = 1;
            }
        }
        
        if (array_key_exists((string)$user, $Enabled)) {
            $this->XML->cagefs_mode = 'on';
        }
    }
    
    // Set CageFS User Status
    public function ChangeUsersStatus() {
        $user = trim((string)$this->XML->params->elid);
        if ($user == '')
        	$user = trim((string)$this->XML->params->name);
        $CageFSMode = (string)$this->XML->params->cagefs_mode;
        if (strlen((string)$this->XML->params->authinfo) == 0) {
            if (strlen($CageFSMode) == 0) {
                CageFSUsers::ChangeUserMode($user,'disable');
            } else {
                CageFSUsers::ChangeUserMode($user,'enable');
            }
        }
        CageFSUsers::HookForSelector($user);
    }
    
    // Add exclude .cagefs folder on backupplan edit
    public function AddExcludeForCagefs() {
    	$file2 = fopen('/usr/local/ispmgr/addon/cagefs/mini_kron.php',"w+");
        fwrite($file2,'<?php passthru(\'/usr/sbin/cagefsctl --hook-install\');');
        fclose($file2);
    }
}