<?php

/**
 * Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
 *
 * Licensed under CLOUD LINUX LICENSE AGREEMENT
 * http://cloudlinux.com/docs/LICENSE.TXT
 */
    /*
     * Title: CageFSManager Module.
     * Version: 1.0.1 (24/Jan/2012)
     * Author: Krishtopin Anton. AKrishtopin@cloudlinux.com
     * Site: http://CloudLinux.com
    */
    
    define ("CAGEFS_SKELETON", "/usr/share/cagefs-skeleton/bin");
    define ("CAGEFS_RESULTFILE", "/var/log/cagefs-update.log");
    define ("CAGEFS_RESULTFILEUPD", "/var/log/cagefs-update.log");
    
class CageFS {

    private $XML = '';
    
    // Set XMLBody
    private function SetXML($val,$rewrite = 0) {
        if (0 == $rewrite)
            $this->XML .= $val;
        else 
            $this->XML = $val;
    }
    
    // Return Success result data
    public function GetResult() {
        $return = '<?xml version="1.0" encoding="UTF-8"?>';
        $return .= '<doc>'.$this->XML.'</doc>';
        echo $return;
    }
    
    // Execute Shell Command
    private function CommandExecute($command,$result = true) {
        if ($result) {
            ob_start();
            passthru($command);
            $return = ob_get_contents();
            ob_end_clean();
            return explode(PHP_EOL,$return);
        } else {
            passthru($command);
            return true;
        }
    }
    
    public function CheckKernel() {
        if (strstr(CageFS::CommandExecute('/usr/sbin/cagefsctl --check-kernel-version'),'supported')) {
            self::SetXML('',1);
            self::SetXML('<elem><message><![CDATA[<div style="margin-left:20px; margin-top:20px;">
            Current running kernel is NOT supported.</div>]]></message></elem>');
            return false;
        } else 
            return true;
    }
    
    //Get User Mode
    private function GetCageFSUserMode($change = false) {
        $result = CageFS::CommandExecute('/usr/sbin/cagefsctl --display-user-mode');
        
        if ( strstr($result[0],"CageFS is disabled") !== FALSE) {
            if ($change) {
                CageFS::CommandExecute('/usr/sbin/cagefsctl --enable-cagefs',false);
            }
            return "CageFS is disabled";
        } else {
            if ($change) {
                CageFS::CommandExecute('/usr/sbin/cagefsctl --disable-cagefs',false);
            }
            if ( strstr($result[0],"Mode: Enable All") !== FALSE) {
                return "New users will be in CageFS";
            } else {
                return "New users will <b>not</b> be in CageFS";
            }
        }
    }
    
    // Check CageFS Init status
    private function CheckSkeleteon () {
        if ( file_exists(CAGEFS_SKELETON) ) {
            if (is_dir (CAGEFS_SKELETON)) {
                return true;
            }
        }
        return false;
    }
    
    // Check CageFS in process list
    private function CheckCagefsCtlExists() {
        $result = CageFS::CommandExecute('ps aux | grep cagefsctl');
        $action = 'none';
        for ($i = 0; $i < count($result); $i++) {
            if (strstr($result[$i], "--init") !== false) {
                $action = "init";
            }
            if (strstr($result[$i], "--reinit") !== false) {
                $action = "init";
        	}
            if (strstr($result[$i], "--update") !== false) {
                $action = "update";
        	}
        }
        return $action;
    }
    
    private function GetCagefsEnabledList() {
        $result = CageFS::CommandExecute('/usr/sbin/cagefsctl --list-enabled');
        unset($result[count($result)-1],$result[count($result)-1],$result[0]);
        asort($result);
        return $result;
    }

    private function GetCagefsDisabledList() {
        $result = CageFS::CommandExecute('/usr/sbin/cagefsctl --list-disabled');
        unset($result[count($result)-1],$result[count($result)-1],$result[0]);
        asort($result);
        return $result;
    }
    
    // Show Main Page Data
    public function ShowMain() {
        self::SetXML('',1);
        if ('init' == CageFS::CheckCagefsCtlExists()) {
            self::SetXML('<redirect>location="ispmgr?func=cagefs.init_progress"</redirect>');
        } else {
            if ('update' == CageFS::CheckCagefsCtlExists()) {
                self::SetXML('<redirect>location="ispmgr?func=cagefs.update_progress"</redirect>');
            } else {
                self::SetXML('<elem>');
                self::SetXML('<message><![CDATA[<table style="margin-left:20px; margin-top:20px; width:98%;"><tr><td style="border:0px;">');
                if (CageFS::CheckSkeleteon()) {
                    self::SetXML(CageFS::GetCageFSUserMode().'<br /><br />');
                    $Enabled = CageFS::GetCagefsEnabledList();
                    $Disabled = CageFS::GetCagefsDisabledList();
                    self::SetXML('<b>Enabled Users</b> ('.count($Enabled).'):<br />');
                    if (count($Enabled) != 0) {
                        foreach ($Enabled as $item) {
                            self::SetXML($item.'; ');
                        }
                        self::SetXML('<br /><br />');
                    }
                    self::SetXML('<b>Disabled Users</b> ('.count($Disabled).'):<br />');
                    if (count($Disabled) != 0) {
                        foreach ($Disabled as $item) {
                            self::SetXML($item.'; ');
                        }
                        self::SetXML('<br />');
                    }
                } else {
                    self::SetXML('CageFS is not Initialized.');
                }
                self::SetXML('</td></tr></table>]]></message>');
                self::SetXML('</elem>');
            }
        }
    }
    
    public function ToggleMode() {
        self::SetXML('',1);
        if ('init' == CageFS::CheckCagefsCtlExists()) {
            self::SetXML('<redirect>location="ispmgr?func=cagefs.init_progress"</redirect>');
        } else {
            if (CageFS::CheckSkeleteon()) {
                if ('update' == CageFS::CheckCagefsCtlExists()) {
                    self::SetXML('<redirect>location="ispmgr?func=cagefs.update_progress"</redirect>');
                } else {
                    CageFS::CommandExecute('/usr/sbin/cagefsctl --toggle-mode',false);
                    self::SetXML('<redirect>location="ispmgr?func=cagefs.main"</redirect>');
                }
            } else {
                self::SetXML('<elem>');
                self::SetXML('<message><![CDATA[<div style="margin-left:20px; margin-top:20px;">');
                self::SetXML('CageFS is not Initialized. Init CageFS to toggle mode.');
                self::SetXML('</div>]]></message>');
                self::SetXML('</elem>');
            }
        }
    }
    
    public function EnableAll() {
        self::SetXML('',1);
        if ('init' == CageFS::CheckCagefsCtlExists()) {
            self::SetXML('<redirect>location="ispmgr?func=cagefs.init_progress"</redirect>');
        } else {
            if (CageFS::CheckSkeleteon()) {
                if ('update' == CageFS::CheckCagefsCtlExists()) {
                    self::SetXML('<redirect>location="ispmgr?func=cagefs.update_progress"</redirect>');
                } else {
                    CageFS::CommandExecute('/usr/sbin/cagefsctl --enable-all',false);
                    self::SetXML('<redirect>location="ispmgr?func=cagefs.main"</redirect>');
                }
            } else {
                self::SetXML('<elem>');
                self::SetXML('<message><![CDATA[<div style="margin-left:20px; margin-top:20px;">');
                self::SetXML('CageFS is not Initialized. Init CageFS to toggle mode.');
                self::SetXML('</div>]]></message>');
                self::SetXML('</elem>');
            }
        }
    }
    
    public function DisableAll() {
        self::SetXML('',1);
        if ('init' == CageFS::CheckCagefsCtlExists()) {
            self::SetXML('<redirect>location="ispmgr?func=cagefs.init_progress"</redirect>');
        } else {
            if (CageFS::CheckSkeleteon()) {
                if ('update' == CageFS::CheckCagefsCtlExists()) {
                    self::SetXML('<redirect>location="ispmgr?func=cagefs.update_progress"</redirect>');
                } else {
                    CageFS::CommandExecute('/usr/sbin/cagefsctl --disable-all',false);
                    self::SetXML('<redirect>location="ispmgr?func=cagefs.main"</redirect>');
                }
            } else {
                self::SetXML('<elem>');
                self::SetXML('<message><![CDATA[<div style="margin-left:20px; margin-top:20px;">');
                self::SetXML('CageFS is not Initialized. Init CageFS to toggle mode.');
                self::SetXML('</div>]]></message>');
                self::SetXML('</elem>');
            }
        }
    }
    
    public function CageFSChangeStatus() {
        self::SetXML('',1);
        if ('init' == CageFS::CheckCagefsCtlExists()) {
            self::SetXML('<redirect>location="ispmgr?func=cagefs.init_progress"</redirect>');
        } else {
            if (CageFS::CheckSkeleteon()) {
                if ('update' == CageFS::CheckCagefsCtlExists()) {
                    self::SetXML('<redirect>location="ispmgr?func=cagefs.update_progress"</redirect>');
                } else {
                    CageFS::GetCageFSUserMode(true);
                    self::SetXML('<redirect>location="ispmgr?func=cagefs.main"</redirect>');
                }
            } else {
                self::SetXML('<elem>');
                self::SetXML('<message><![CDATA[<div style="margin-left:20px; margin-top:20px;">');
                self::SetXML('CageFS is not Initialized. Init CageFS to enable|disable CageFS.');
                self::SetXML('</div>]]></message>');
                self::SetXML('</elem>');
            }
        }
    }
    
    public function CageFSUpdateStart() {
        self::SetXML('',1);
        if ('init' == CageFS::CheckCagefsCtlExists()) {
            self::SetXML('<redirect>location="ispmgr?func=cagefs.init_progress"</redirect>');
        } else {
            if (CageFS::CheckSkeleteon()) {
                if ('none' == CageFS::CheckCagefsCtlExists()) {
        	  	    $command = "/usr/sbin/cagefsctl --update --do-not-ask --silent &>/dev/null &";
        	  	    CageFS::CommandExecute($command,true);
                }
                self::SetXML('<redirect>location="ispmgr?func=cagefs.update_progress"</redirect>');
            } else {
                self::SetXML('<elem>');
                self::SetXML('<message><![CDATA[<div style="margin-left:20px; margin-top:20px;">');
                self::SetXML('CageFS is not Initialized. Init CageFS to update CageFS Skeleton.');
                self::SetXML('</div>]]></message>');
                self::SetXML('</elem>');
            }
        }
    }
    
    public function CageFSUpdateProgress() {
        self::SetXML('',1);
        if (CageFS::CheckSkeleteon()) {
            
            if ('none' == CageFS::CheckCagefsCtlExists()) {
                self::SetXML('<redirect>location="ispmgr?func=cagefs.update_done"</redirect>');
            } else {
                if (file_exists (CAGEFS_RESULTFILEUPD)) {
                    $content = file(CAGEFS_RESULTFILEUPD,FILE_SKIP_EMPTY_LINES);
                    if (count($content) > 100) {
                        $Out = '...<br />...<br />...<br />';
                        for ($i = (count($content)-100); $i < (count($content)-1); $i++) {
                            $Out .= $i.'. '.$content[$i].'<br />';
                        }
                    } else {
                        foreach ($content as $key => $value) {
                            $Out .= $key.'. '.$value.'<br />';
                        }
                    }
                    self::SetXML('<elem>');
                    self::SetXML('<message><![CDATA[<div style="margin-left:20px; margin-top:20px;">Updating Skeleton<br /><br /><div id="UpdateProgress" style="width:80%; border: 1px solid #000000; height:400px; overflow-y: auto; font-size:14px;">');
                    self::SetXML($Out);
                    self::SetXML('</div></div>]]></message>');
                    self::SetXML('</elem>');
                }
            }
            
        } else {
            self::SetXML('<elem>');
            self::SetXML('<message><![CDATA[<div style="margin-left:20px; margin-top:20px;">');
            self::SetXML('CageFS is not Initialized. Init CageFS to update CageFS Skeleton.');
            self::SetXML('</div>]]></message>');
            self::SetXML('</elem>');
        }
    }
    
    public function CageFSUpdateDone() {
        self::SetXML('',1);
        if (CageFS::CheckSkeleteon()) {
            
            if ('update' == CageFS::CheckCagefsCtlExists()) {
                self::SetXML('<redirect>location="ispmgr?func=cagefs.update_progress"</redirect>');
            } else {
                if (file_exists (CAGEFS_RESULTFILEUPD)) {
                    $content = file(CAGEFS_RESULTFILEUPD,FILE_SKIP_EMPTY_LINES);
                    if (count($content) > 100) {
                        $Out = '...<br />...<br />...<br />';
                        for ($i = (count($content)-100); $i < (count($content)-1); $i++) {
                            $Out .= $i.'. '.$content[$i].'<br />';
                        }
                    } else {
                        foreach ($content as $key => $value) {
                            $Out .= $key.'. '.$value.'<br />';
                        }
                    }
                }
                
                self::SetXML('<elem>');
                self::SetXML('<message><![CDATA[<div style="margin-left:20px; margin-top:20px; font-size:16px;">Update Complete<br /><br /><div id="UpdateProgress" style="width:80%; border: 1px solid #000000; height:400px; overflow-y: auto; font-size:14px;">');
                self::SetXML($Out);
                self::SetXML('</div></div>]]></message>');
                self::SetXML('</elem>');
            }
            
        } else {
            self::SetXML('<elem>');
            self::SetXML('<message><![CDATA[<div style="margin-left:20px; margin-top:20px;">');
            self::SetXML('CageFS is not Initialized. Init CageFS to update CageFS Skeleton.');
            self::SetXML('</div>]]></message>');
            self::SetXML('</elem>');
        }
    }
    
    public function CageFSInitStart() {
        self::SetXML('',1);
        if (!CageFS::CheckSkeleteon()) {
            if ('none' == CageFS::CheckCagefsCtlExists()) {
    	  	    $command = "/usr/sbin/cagefsctl --init --do-not-ask --silent &>/dev/null &";
    	  	    CageFS::CommandExecute($command,true);
            }
            self::SetXML('<redirect>location="ispmgr?func=cagefs.init_progress"</redirect>');
        } else {
            self::SetXML('<elem>');
            self::SetXML('<message><![CDATA[<div style="margin-left:20px; margin-top:20px;">');
            self::SetXML('CageFS is already Initialized.');
            self::SetXML('</div>]]></message>');
            self::SetXML('</elem>');
        }
    }
    
    public function CageFSInitProgress() {
        self::SetXML('',1);
            
        if ('none' == CageFS::CheckCagefsCtlExists()) {
            self::SetXML('<redirect>location="ispmgr?func=cagefs.init_done"</redirect>');
        } else {
            if (file_exists (CAGEFS_RESULTFILE)) {
                $content = file(CAGEFS_RESULTFILE,FILE_SKIP_EMPTY_LINES);
                if (count($content) > 100) {
                    $Out = '...<br />...<br />...<br />';
                    for ($i = (count($content)-100); $i < (count($content)-1); $i++) {
                        $Out .= $i.'. '.$content[$i].'<br />';
                    }
                } else {
                    foreach ($content as $key => $value) {
                        $Out .= $key.'. '.$value.'<br />';
                    }
                }
                self::SetXML('<elem>');
                self::SetXML('<message><![CDATA[<div style="margin-left:20px; margin-top:20px;">Init Skeleton<br /><br /><div id="UpdateProgress" style="width:80%; border: 1px solid #000000; height:400px; overflow-y: auto; font-size:14px;">');
                self::SetXML($Out);
                self::SetXML('</div></div>]]></message>');
                self::SetXML('</elem>');
            }
        }
    }
    
    public function CageFSInitDone() {
        self::SetXML('',1);
            
        if ('init' == CageFS::CheckCagefsCtlExists()) {
            self::SetXML('<redirect>location="ispmgr?func=cagefs.init_progress"</redirect>');
        } else {
            if (file_exists (CAGEFS_RESULTFILE)) {
                $content = file(CAGEFS_RESULTFILE,FILE_SKIP_EMPTY_LINES);
                if (count($content) > 100) {
                    $Out = '...<br />...<br />...<br />';
                    for ($i = (count($content)-100); $i < (count($content)-1); $i++) {
                        $Out .= $i.'. '.$content[$i].'<br />';
                    }
                } else {
                    foreach ($content as $key => $value) {
                        $Out .= $key.'. '.$value.'<br />';
                    }
                }
            }
            
            self::SetXML('<elem>');
            self::SetXML('<message><![CDATA[<div style="margin-left:20px; margin-top:20px; font-size:16px;">CageFS was Initialized.<br /><br /><div id="UpdateProgress" style="width:80%; border: 1px solid #000000; height:400px; overflow-y: auto; font-size:14px;">');
            self::SetXML($Out);
            self::SetXML('</div></div>]]></message>');
            self::SetXML('</elem>');
        }
    }
}