#!/usr/bin/php -n
<?php
/**
 * Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
 *
 * Licensed under CLOUD LINUX LICENSE AGREEMENT
 * http://cloudlinux.com/docs/LICENSE.TXT
 */

    /*
     * Title: CageFS Manager Module for external API queries to ISP Manager
     * Version: 1.0.0 (26/Feb/2014)
    */

set_time_limit(0);
error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);
ini_set('display_errors', 0);

if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    $RequestString = urldecode($_SERVER['QUERY_STRING']);  
    if ( strstr($RequestString, 'func=user.edit') ) {
        // Example:
        // $RequestString = "authinfo=root:rootPassw&func=user.edit&out=xml&sok=ok&name=username&passwd=userpassw&owner=root&disklimit=100&cagefs=yes"

        // Find username in string
        $username = "";
        $req_parts = explode ( "&", $RequestString );
        foreach ( $req_parts as &$part ) {
            $part = trim ( $part );
            if ( strpos ( $part, "name=" ) === 0 ) {
                $username = str_replace ( "name=", "", $part );
                if ( $username != "" ) {
                    $username = strtolower ( $username );
                    // Recommedation ISP Manager's support team
                    // Some delay - wait for system update /etc/passwd database
                    sleep ( 5 );
                    passthru ( "/usr/sbin/cagefsctl --set-default-user-status {$username} 2>/dev/null" );
                    passthru ( "/usr/sbin/cagefsctl --cpetc {$username} 2>/dev/null" );
                }
                break;
            }
        }
        echo ( "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<doc/>\n" );
    }
}
