#!/usr/bin/php -n
<?php
/**
 * Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
 *
 * Licensed under CLOUD LINUX LICENSE AGREEMENT
 * http://cloudlinux.com/docs/LICENSE.TXT
 */

    /*
     * Title: CageFS Manager Module.
     * Version: 1.2.0 (20/Feb/2014)
    */

set_time_limit(0);
error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);
ini_set('display_errors', 0);

// Include Commands Class
include_once('cagefs/CagefsUsers.class.php');


$lockfile = fopen('/usr/local/ispmgr/addon/cagefs/.lock.mutex','w+');
if (flock($lockfile, LOCK_EX)) {
	$dir = opendir('/usr/local/ispmgr/addon/cagefs/');
	while($filename = readdir($dir)) {
		if (strstr($filename,'postcreate')) {
			$username = str_replace('.postcreate.','',$filename);
			passthru("/usr/sbin/cagefsctl --set-default-user-status {$username}");
			passthru("/usr/sbin/cagefsctl --cpetc {$username}");
			@unlink('/usr/local/ispmgr/addon/cagefs/'.$filename);
		}
	}
	flock($lockfile, LOCK_UN);
}
fclose($lockfile);
@unlink('/usr/local/ispmgr/addon/cagefs/.lock.mutex');


if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $commands = new CageFSUsers(file_get_contents('php://stdin'));
    $commands->ChangeUsersStatus();
    $commands->PrintXml();
} else { //GET
    $RequestString = $_SERVER['QUERY_STRING'];

    // Tmp Logger
//    $file = fopen('/usr/local/ispmgr/addon/test.log',"a+");
//    fwrite($file,PHP_EOL.$RequestString);
//    fclose($file);

    $RequestString = urldecode($RequestString);
    
    // Please forgive me God
    if ('' == $_ENV['REMOTE_USER'])
        $_ENV['REMOTE_USER'] = $_SERVER['REMOTE_USER'];
        
    // Output for users page
    if (strstr($RequestString, 'func=user.edit') && strstr($RequestString, 'elid=')) {
        $commands = new CageFSUsers(file_get_contents('php://stdin'));
        $commands->GetCagefsUser($RequestString);
        $commands->PrintXml();
    } elseif (strstr($RequestString, 'func=user')) {
        $commands = new CageFSUsers(file_get_contents('php://stdin'));
        $commands->GetCageUsers();
        $commands->PrintXml();
    }
}
