<?php

/**
 * Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
 *
 * Licensed under CLOUD LINUX LICENSE AGREEMENT
 * http://cloudlinux.com/docs/LICENSE.TXT
 */

#Title: CloudLinux CageFS manager.                                                                                                                                
#Version: 1.0.1 (13/Jan/2011)                                                                                                                                
#Author: Anton Krishtopin (AKrishtopin@Cloudlinux.com)                                                                                                        
#Site: http://cloudLinux.com 
    
include('commands.php');

class Ctrl_Nodeworx_Cagefs extends Ctrl_Nodeworx_Plugin {

    public function indexAction() {
        if (CheckKernel()) {
            if (!CheckSkeleteon()) {
                $this->getView()->assign( 'title', 'CageFS is not initialized' );
                $this->getView()->assign( 'template', 'admin/Start' );
            } else {
                if ('update' == CheckCagefsCtlExists()) {
                    echo '<script>window.document.location.href = "cagefs/update"</script>';
                    exit();
                }
                
                if ('init' == CheckCagefsCtlExists()) {
                    echo '<script>window.document.location.href = "cagefs/init"</script>';
                    exit();
                }
                
                $disabled = GetCagefsDisabledList();
                $enabled = GetCagefsEnabledList();
                
                if (!$CageFSMode = CheckCagefsMode()) {
                    $this->getView()->assign( 'title', 'CageFS User Manager' );
                    $this->getView()->assign( 'template', 'admin/CageFSDisabled' );
                } else {
                    $this->getView()->assign( 'title', 'CageFS User Manager' );
                    $this->getView()->assign( 'template', 'admin/index' );
                    $this->getView()->assign( 'enabled', $enabled );
                    $this->getView()->assign( 'disabled', $disabled );
                    $this->getView()->assign( 'CageFSMode', $CageFSMode );
                }
            }
        } else {
            $this->getView()->assign( 'title', 'Kernel is NOT supported' );
            $this->getView()->assign( 'template', 'admin/CageFSKernel' );
        }
    }
}
