#!/opt/alt/python37/bin/python3.7 -bb
# -*- coding: utf-8 -*-

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT
from __future__ import print_function
from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals
from future import standard_library
standard_library.install_aliases()
from builtins import *
import subprocess


def first_quot(line, isquotf):
    if line[0] == "\"" and isquotf == 0:
        return 1
    return 0

def last_quot(line, isquotf):
    if line[len(line)-1]=='\"' and isquotf == 1:
        return 1
    return 0

def parse_command(command):
    command = command.split(" ")
    isquot=0
    res = ""
    result = []
    for i in range(len(command)):
        if command[i] != "":
            if first_quot(command[i], isquot) == 1:
                isquot = 1
                res = command[i]
                continue
            if last_quot(command[i], isquot) == 1:
                isquot = 0
                res +=" "+command[i]
                result.append(res)
                continue
            result.append(command[i])
    print(result)



def exec_command(command):
    result = []
    try:
        p = subprocess.Popen(command, shell=True, stdout=subprocess.PIPE, text=True)
        while 1:
            output = p.stdout.readline()
            if not output:
                break;
            if output.strip()!="":
                result.append(output.strip())
    except Exception as inst:
        print("Call process error: "+str(inst))
    return result


def exec_command_null_input(command, merge_stderr = False):
    try:
        if merge_stderr:
            p = subprocess.Popen(command, shell=True,
                                 stdout=subprocess.PIPE,
                                 stderr=subprocess.STDOUT,
                                 stdin=open('/dev/null'),
                                 text=True)
        else:
            p = subprocess.Popen(command, shell=True,
                                 stdout=subprocess.PIPE,
                                 stdin=open('/dev/null'),
                                 text=True)
        (out, _) = p.communicate()
    except OSError:
        print('Error: failed to run ', command)
        return []
    return out



def exec_command_find_substring(command, substring):
    result = exec_command(command)
    for i in result:
        if substring in i:
            return i
    return -1
