<?php
/**
 * Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
 *
 * Licensed under CLOUD LINUX LICENSE AGREEMENT
 * http://cloudlinux.com/docs/LICENSE.TXT
 */

// Session data
$_SESSION = array();

// Session store filename
$session_file_name = "";

$CL_CAPTAIN_BINARY = '/usr/share/python-cllib/cl.captain';

// Prints error message and terminates the script
function _print_error_and_exit ( $message )
{
    echo '<center><b><font size="7" color="red">'.$message.'</font></b></center>';
    exit ( 0 );
} // _print_error_and_exit


function _create_directory_exit_if_error ( $dir_name, $mode )
{
    global $CL_CAPTAIN_BINARY;

    if ( is_dir ( $dir_name ) )
        // Directory present - do nothing
        return;
    if ( !mkdir ( $dir_name, 0700, true ))
    { // Unable to create directory for user's session files, try to create it via cl.captain
        $command = $CL_CAPTAIN_BINARY . ' -d ' . $dir_name . ' -m 0700 2>&1';
        ob_start();
        passthru($command);
        $result = ob_get_contents();
        ob_end_clean();

        if ( $result != '' )
            // cl.captain returns error
            _print_error_and_exit ( "Failed to create directory " . $dir_name );
    } // if

    # Directory successfully created, set permissions for it
    chmod ( $dir_name, $mode );
} // _create_directory_exit_if_error

// create directory for user's files
function _create_dir_for_user_files ( )
{
    $cagefs_dir = $_SERVER['HOME'] . '/.cagefs'; //.cagefs
    $dir_name = $cagefs_dir . '/tmp';

    _create_directory_exit_if_error ( $cagefs_dir, 0771 );
    _create_directory_exit_if_error ( $dir_name, 0700 );

    return $dir_name;
} // _create_dir_for_user_files

// write file via cl.captain
function _write_file_via_captain ( $filename, $content )
{
    global $CL_CAPTAIN_BINARY;

    //////////////
    // Write file via cl.captain
    $descriptorspec = array (
       0 => array("pipe", "r"),  // stdin
       1 => array("pipe", "w"),  // stdout
       2 => array("pipe", "w")   // stderr
    );

    // Prepare process start without specifying current work directory and environment
    $command = $CL_CAPTAIN_BINARY . ' -f ' . $filename . ' 2>&1';
    $process = proc_open ( $command, $descriptorspec, $pipes, NULL, NULL );

    if ( is_resource ( $process ) )
    {
        // Put serialized $_SESSION to stdin
        fwrite($pipes[0], serialize ( $_SESSION ));
        fclose ( $pipes[0] );

        // Close stdout
        $cl_captain_stdout = stream_get_contents ( $pipes[1] );
        fclose ( $pipes[1] );

        // Close stderr
        fclose ( $pipes[1] );

        $return_value = proc_close ( $process );
        if ( $return_value != 0 )
            // cl.captain returns error
            _print_error_and_exit ( "Can't write file " . $filename . ':' . $cl_captain_stdout );
    } // if
    else
        _print_error_and_exit ( "Can't write file " . $filename );
} // _write_file_via_captain

// Session initialize
function sess_init ( )
{
    global $_SESSION, $session_file_name;

    // create directory for user's files
    $dir_name = _create_dir_for_user_files ( );

    // Init session mechanism using DirectAdmin session id
    // http://www.directadmin.com/features.php?id=362
    $session_file_name = $dir_name . "/cagefs_" . getenv("SESSION_ID");
    error_reporting(0);

    // Try to read session data from file
    $fp = fopen($session_file_name, "r");
    // if file opened successfully, read session data
    if ($fp != FALSE) {
        $contents = fread($fp, filesize($session_file_name));
        fclose($fp);
        $_SESSION = unserialize($contents);
    } // if
} // sess_init

// Session data save
function sess_data_save ( )
{
    global $_SESSION, $session_file_name;
    $s_to_write = serialize ( $_SESSION );

    // Save to file
    $fp = fopen ( $session_file_name, "w" );
    if ( $fp )
    {
        fwrite ( $fp, $s_to_write );
        fclose ( $fp );
    } // if
    else
    { // file open  error, try to write it via captain
        _write_file_via_captain ( $session_file_name, $s_to_write );
    } // else

    // Set rights to file
    chmod ( $session_file_name, 0600 );
} // sess_data_save
