<script language="javascript">
/**
 * Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
 *
 * Licensed under CLOUD LINUX LICENSE AGREEMENT
 * http://cloudlinux.com/docs/LICENSE.TXT
 */
    var DisableFilter = 0;
    var EnableFilter = 0;
    
    var enabled = new Array(
    <?php
        if (count($enabled) != 0) {
            $i = 1;
            foreach ($enabled as $value) {
                if ($i == count($enabled))
                    echo '"'.$value.'"'.PHP_EOL;
                else
                    echo '"'.$value.'",'.PHP_EOL;
                $i++;
            }
        }  
    ?>
    ); 
    
    var disabled = new Array(
    <?php    
        echo PHP_EOL.PHP_EOL;
        
        if (count($disabled) != 0) {
            $i = 1;
            foreach ($disabled as $value) {
                if ($i == count($disabled))
                    echo '"'.$value.'"'.PHP_EOL;
                else
                    echo '"'.$value.'",'.PHP_EOL;
                $i++;
            }
        }  
    ?>      
    );      
    
    var DisabledSelected = Array();
    var EnabledSelected = Array();

    // Simple visualization
    function ChangeModeStart() {
        document.getElementById('ChangeUsersMode').style.display = 'none';
        document.getElementById('ChangeUsersProgress').style.display = 'block';
    }
    
    function ChangeModeEnd() {
        document.getElementById('ChangeUsersProgress').style.display = 'none';
        document.getElementById('ChangeUsersMode').style.display = 'block';
    }
    // End Simple visualization
    
    function DisabledFilter(str) {
        if (str.length >= 1) {
            DisableFilter = 1;
            for (i=0; i<disabled.length; i++) {
                if(disabled[i].toLowerCase().indexOf(str.toLowerCase()) + 1) {
                    DisabledSelected.push(disabled[i]);
                }
            }
            DisabledSelected.sort();
            document.getElementById('DisabledSelect').innerHTML = '';
            for (i=0; i<DisabledSelected.length; i++) {
                var elOptNew = document.createElement('option');
                    elOptNew.text = DisabledSelected[i];
                    elOptNew.value = DisabledSelected[i];
                try {
                    document.getElementById('DisabledSelect').add(elOptNew, null); // standards compliant; doesn't work in IE
                } catch(ex) {
                    document.getElementById('DisabledSelect').add(elOptNew); // IE only
                }
            }
        } else {
            if (DisableFilter) {
                DisableFilter = 0;
                document.getElementById('DisabledSelect').innerHTML = '';
                for (i=0; i<disabled.length; i++) {
                    var elOptNew = document.createElement('option');
                        elOptNew.text = disabled[i];
                        elOptNew.value = disabled[i];
                    try {
                        document.getElementById('DisabledSelect').add(elOptNew, null); // standards compliant; doesn't work in IE
                    } catch(ex) {
                        document.getElementById('DisabledSelect').add(elOptNew); // IE only
                    }
                }   
            }
        }
        DisabledSelected = Array();
    }
    
    function EnabledFilter(str) {
        if (str.length >= 1) {
            EnableFilter = 1;
            for (i=0; i<enabled.length; i++) {
                if(enabled[i].toLowerCase().indexOf(str.toLowerCase()) + 1) {
                    EnabledSelected.push(enabled[i]);
                }
            }
            EnabledSelected.sort();
            document.getElementById('EnabledSelect').innerHTML = '';
            for (i=0; i<EnabledSelected.length; i++) {
                var elOptNew = document.createElement('option');
                    elOptNew.text = EnabledSelected[i];
                    elOptNew.value = EnabledSelected[i];
                try {
                    document.getElementById('EnabledSelect').add(elOptNew, null); // standards compliant; doesn't work in IE
                } catch(ex) {
                    document.getElementById('EnabledSelect').add(elOptNew); // IE only
                }
            }
        } else {
            if (EnableFilter) {
                EnableFilter = 0;
                document.getElementById('EnabledSelect').innerHTML = '';
                for (i=0; i<enabled.length; i++) {
                    var elOptNew = document.createElement('option');
                        elOptNew.text = enabled[i];
                        elOptNew.value = enabled[i];
                    try {
                        document.getElementById('EnabledSelect').add(elOptNew, null); // standards compliant; doesn't work in IE
                    } catch(ex) {
                        document.getElementById('EnabledSelect').add(elOptNew); // IE only
                    }
                }   
            }
        }
        EnabledSelected = Array();
    }
    
    function moveEnabled() {
        users_list = '';
        for(i=0; i<document.getElementById('EnabledSelect').options.length; i++)
        {
            if (document.getElementById('EnabledSelect').options[i].selected == true) {
                disabled.push(document.getElementById('EnabledSelect').options[i].value);
                for (j=0; j<enabled.length; j++) {
                    if(enabled[j].toLowerCase().indexOf(document.getElementById('EnabledSelect').options[i].value.toLowerCase()) + 1) {
                        enabled.splice(j,1);
                    }
                }
                users_list = users_list + document.getElementById('EnabledSelect').options[i].value + '|';
            }
        }
        
        disabled.sort();
        enabled.sort();

        rebuildSelectBoxes();
        
        return users_list;
    }
    
    function moveDisabled() {
        users_list = '';
        for(i=0; i<document.getElementById('DisabledSelect').options.length; i++)
        {
            if (document.getElementById('DisabledSelect').options[i].selected == true) {
                enabled.push(document.getElementById('DisabledSelect').options[i].value);
                for (j=0; j<disabled.length; j++) {
                    if(disabled[j].toLowerCase().indexOf(document.getElementById('DisabledSelect').options[i].value.toLowerCase()) + 1) {
                        disabled.splice(j,1);
                    }
                }
                users_list = users_list + document.getElementById('DisabledSelect').options[i].value + '|';
            }
        }
        
        disabled.sort();
        enabled.sort();

        rebuildSelectBoxes();
        
        return users_list;
    }
    
    function rebuildSelectBoxes() {

        document.getElementById('EnabledUsers').innerHTML = enabled.length;
        document.getElementById('DisabledUsers').innerHTML = disabled.length;

        document.getElementById('DisabledSelect').innerHTML = '';
        for (i=0; i<disabled.length; i++) {
            var elOptNew = document.createElement('option');
                elOptNew.text = disabled[i];
                elOptNew.value = disabled[i];
            try {
                document.getElementById('DisabledSelect').add(elOptNew, null); // standards compliant; doesn't work in IE
            } catch(ex) {
                document.getElementById('DisabledSelect').add(elOptNew); // IE only
            }
        }
        
        document.getElementById('EnabledSelect').innerHTML = '';
        for (i=0; i<enabled.length; i++) {
            var elOptNew = document.createElement('option');
                elOptNew.text = enabled[i];
                elOptNew.value = enabled[i];
            try {
                document.getElementById('EnabledSelect').add(elOptNew, null); // standards compliant; doesn't work in IE
            } catch(ex) {
                document.getElementById('EnabledSelect').add(elOptNew); // IE only
            }
        }
        
        document.getElementById('DisabledFilter').value = '';
        document.getElementById('EnabledFilter').value = '';
    }
    
    function change(status, ajax_url) {
        if (status == 'Disable All') {
            if (confirm("Do you want new users not to be in CageFS?")) {
                document.getElementById('MainContent').style.display = 'none';
                document.getElementById('ChangeCageFSMode').style.display = 'block';
                ajax(ajax_url,'ajax_container','Reload');
            }
        } else {
            if (confirm("Do you want new users to be in CageFS?")) {
                document.getElementById('MainContent').style.display = 'none';
                document.getElementById('ChangeCageFSMode').style.display = 'block';
                ajax(ajax_url,'ajax_container','Reload');
            }
        }
    }
    
    function DisableCageFS(status,ajax_url) {
        if ('enabled' == status)
            if (confirm("Do you want disable CageFS?")) {
                document.getElementById('MainContent').style.display = 'none';
                document.getElementById('ChangeCageFSStatus').style.display = 'block';
                ajax(ajax_url,'ajax_container','Reload');
            }
        if ('disabled' == status) {
            if (confirm("Do you want enable CageFS?")) {
                document.getElementById('MainContent').style.display = 'none';
                document.getElementById('ChangeCageFSStatus').style.display = 'block';
                ajax(ajax_url,'ajax_container','Reload');
            }
        }
    }
    
    function UpdateCageFS(url) {
        if (confirm("Do you want to update CageFS Skeleton?")) {
            return true;
        } else {
            return false;
        }
    }
</script>