<?php
/**
 * Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
 *
 * Licensed under CLOUD LINUX LICENSE AGREEMENT
 * http://cloudlinux.com/docs/LICENSE.TXT
 */

    class CagefsCommands {

        private function CommandExecute($command,$result = true) {
            if ($result) {
                $return = shell_exec($command);
                return explode(PHP_EOL,$return);
            } else {
                shell_exec($command);
                return true;
            }
        }
        
        private function ShellExecute($command,$result = true) {
            if ($result) {
                $return = shell_exec($command);
                return $return;
            } else {
                shell_exec($command);
                return true;
            }
        }
        
        public function CheckKernel() {
            if (strstr(CagefsCommands::ShellExecute('/usr/bin/sudo /usr/sbin/cagefsctl --check-kernel-version'),'supported')) {
                return false;
            } else 
                return true;
        }

        public function CheckCagefsCtlExists() {
            $result = $this->CommandExecute('/usr/bin/sudo /bin/ps aux | /bin/grep cagefsctl',true);
            $action = 'none';
            for ($i = 0; $i < count($result); $i++) {
                if (strstr($result[$i], "--init") !== false) {
                    $action = "init";
                }
                if (strstr($result[$i], "--reinit") !== false) {
                    $action = "init";
            	}
                if (strstr($result[$i], "--update") !== false) {
                    $action = "update";
            	}
            }
            return $action;
        }

        public function CheckSkeleteon () {
            if ( file_exists(CAGEFS_SKELETON) ) {
                if (is_dir (CAGEFS_SKELETON)) {
                    return true;
                }
            }
            return false;
        }

        public function CheckCagefsMode() {
            $result = $this->CommandExecute('/usr/bin/sudo /usr/sbin/cagefsctl --display-user-mode');
            
            if ( strstr($result[0],"CageFS is disabled") !== FALSE) {
                return false;
            } else {
                if ( strstr($result[0],"Mode: Enable All") !== FALSE) {
                    $res['mode'] = 'Enabled by default';
                    $res['change'] = 'Disable All';
                    $res['status'] = 'enable all';
                } else {
                    $res['mode'] = 'Disabled by default';
                    $res['change'] = 'Enable All';
                    $res['status'] = 'disable all';
                }
            }
            return $res;
        }

        public function ChangeCageFSStatus($action) {
            if ('disable' == $action) {
                $this->CommandExecute('/usr/bin/sudo /usr/sbin/cagefsctl --disable-cagefs',false);
            } else {
                $this->CommandExecute('/usr/bin/sudo /usr/sbin/cagefsctl --enable-cagefs',false);
            }
        }

        public function ChangeCageFSMode($mode) {
            if ('disabled' == $mode) {
                $this->CommandExecute('/usr/bin/sudo /usr/sbin/cagefsctl --toggle-mode',false);
            } else {
                $this->CommandExecute('/usr/bin/sudo /usr/sbin/cagefsctl --toggle-mode',false);
            }
        }

        public function ChangeUserMode($mode, $users) {
            if (!empty($users)) {
                $users = explode('|',$users);
        		unset($users[count($users)-1]);
                switch ($mode) {
                	case 'enable':
                		foreach ($users as $item) {
                		    $this->CommandExecute('/usr/bin/sudo /usr/sbin/cagefsctl --enable '.trim($item),false);
                		}
            		break;
                	case 'disabled':
                		foreach ($users as $item) {
                		    $this->CommandExecute('/usr/bin/sudo /usr/sbin/cagefsctl --disable '.trim($item),false);
                		}
            		break;
                }
            }
        }

        public function GetCagefsEnabledList() {
            $result = $this->CommandExecute('/usr/bin/sudo /usr/sbin/cagefsctl --list-enabled');
            unset($result[count($result)-1],$result[count($result)-1],$result[0]);
//            $result = $this->ClearSystemUsers($result); // Temp action remove after CageFS update
            asort($result);
            return $result;
        }

        public function GetCagefsDisabledList() {
            $result = $this->CommandExecute('/usr/bin/sudo /usr/sbin/cagefsctl --list-disabled');
            unset($result[count($result)-1],$result[count($result)-1],$result[0]);
//            $result = $this->ClearSystemUsers($result); // Temp action remove after CageFS update
            asort($result);
            return $result;
        }

        
        public function InitCageFS() {
            global $RequestParams;
            
            if ('init' != $this->CheckCagefsCtlExists() && ($RequestParams['start'] == 'true') ) {
        	  	$command = "/usr/bin/sudo /usr/sbin/cagefsctl --init --do-not-ask --silent &>/dev/null &";
        	  	$this->CommandExecute($command,true);
            }
            
            if ('none' == $this->CheckCagefsCtlExists()) {
                $content = file(CAGEFS_RESULTFILE,FILE_SKIP_EMPTY_LINES);
                if (count($content) > 100) {
                    for ($i = 0; $i < (count($content)-1); $i++) {
                        $Out .= $i.'. '.$content[$i].'<br />';
                    }
                } else {
                    foreach ($content as $key => $value) {
                        $Out .= $key.'. '.$value.'<br />';
                    }
                }
                $Out .= '<br /><b>Init complete</b>';
                $Out .= '<script>UpdateComplete();</script>';
                return $Out;
            }
            
            if ('init' == $this->CheckCagefsCtlExists()) {
                $content = file(CAGEFS_RESULTFILE,FILE_SKIP_EMPTY_LINES);
                if (count($content) > 100) {
                    $Out = '...<br />...<br />...<br />';
                    for ($i = (count($content)-100); $i < (count($content)-1); $i++) {
                        $Out .= $i.'. '.$content[$i].'<br />';
                    }
                } else {
                    foreach ($content as $key => $value) {
                        $Out .= $key.'. '.$value.'<br />';
                    }
                }
                if ($RequestParams['start'] == 'true') {
                    $Out = '';
                }
                $Out .= '<script>Progress();</script>';
                return $Out;
            }
            return null;
        }
        
        public function UpdateCageFS() {
            global $RequestParams;
            
            if (!$this->CheckSkeleteon()) {
                return false;
            }
            
            if ('update' != $this->CheckCagefsCtlExists() && ($RequestParams['start'] == 'true') ) {
        	  	$command = "/usr/bin/sudo /usr/sbin/cagefsctl --update --do-not-ask --silent &>/dev/null &";
        	  	$this->CommandExecute($command);
            }
            
            
            if ('none' == $this->CheckCagefsCtlExists()) {
                if (file_exists (CAGEFS_RESULTFILEUPD)) {
                    $content = file(CAGEFS_RESULTFILEUPD,FILE_SKIP_EMPTY_LINES);
                } else {
                    $content = '';
                }
                if (count($content) > 100) {
                    for ($i = 0; $i < (count($content)-1); $i++) {
                        $Out .= $i.'. '.$content[$i].'<br />';
                    }
                } else {
                    foreach ($content as $key => $value) {
                        $Out .= $key.'. '.$value.'<br />';
                    }
                }
                $Out .= '<br /><b>Update complete</b>';
                $Out .= '<script>UpdateComplete();</script>';
                return $Out;
            }
            
            if ('update' == $this->CheckCagefsCtlExists()) {
                if (file_exists (CAGEFS_RESULTFILEUPD)) {
                    $content = file(CAGEFS_RESULTFILEUPD,FILE_SKIP_EMPTY_LINES);
                } else {
                    $content = '';
                }
                if (count($content) > 100) {
                    $Out = '...<br />...<br />...<br />';
                    for ($i = (count($content)-100); $i < (count($content)-1); $i++) {
                        $Out .= $i.'. '.$content[$i].'<br />';
                    }
                } else {
                    foreach ($content as $key => $value) {
                        $Out .= $key.'. '.$value.'<br />';
                    }
                }
                if ($RequestParams['start'] == 'true') {
                    $Out = '';
                }
                $Out .= '<script>Progress();</script>';
                return $Out;
            }
            return null;
        }

        // Temp function
        private function ClearSystemUsers($users = array()) {
            $return = array();
            foreach ($users as $key => $item) {
                if ( (!strstr($item,'cpanel')) && ('mailman' != $item) && ('nfsnobody' != $item) ) {
                	$return[] = $item;
                }
            }
            return $return;
        }
    }

    $commands = new CagefsCommands();