#!/bin/sh
eval 'if [ -x /usr/local/cpanel/3rdparty/bin/perl ]; then exec /usr/local/cpanel/3rdparty/bin/perl -x -- $0 ${1+"$@"}; else exec /usr/bin/perl -x -- $0 ${1+"$@"};fi'
if 0;
#!/usr/bin/perl

# CloudLinux - whostmgr/docroot/cgi/addon_cagefs.cgi Copyright(c) 2010 CloudLinux, Inc.
#                                                                  All rights Reserved.
#                                                             http://www.cloudlinux.com
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#WHMADDON:cagefs:CageFS

#Title: cPanel CageFS plugin.
#Version: 1.0.1 (05/Dec/2011)
#Author: Berezhok Alexey (alexey_com@ukr.net)
#Site: http://cloudLinux.com

BEGIN { unshift @INC, '/usr/local/cpanel'; }

use strict;
use Cpanel::SafeRun::Errors;
use Whostmgr::ACLS          ();
use Whostmgr::HTMLInterface ();
use Cpanel::Encoder::Tiny   ();
use Cpanel::Form            ();
use XML::LibXML             ();
use Data::Dumper;

use constant CAGEFS_SKELETON => "/usr/share/cagefs-skeleton/bin";
use constant CAGEFS_RESULTFILE => "/var/log/cagefs-update.log";
use constant CAGEFS_RESULTFILEUPD => "/var/log/cagefs-update.log";

my %FORM      = Cpanel::Form::parseform();

if(defined $FORM{'action'}){
my $cgiaction = $FORM{'action'};
if ($cgiaction eq 'get_update_log'){
	print "Cache-Control: no-cache, must-revalidate\n";
        print "Content-Type: text/html\n";
        print 'Content-Disposition: attachment; filename="cagefs-update.log"';
	my $filesize = -s CAGEFS_RESULTFILEUPD;
        print "Content-Length: $filesize.\n\n";
	undef $/;
	open (FILE,CAGEFS_RESULTFILEUPD);
	my $file = <FILE>;
	close(FILE);
	print "$file";
	exit;
}

if ($cgiaction eq 'get_init_log'){
	print "Cache-Control: no-cache, must-revalidate\n";
        print "Content-Type: text/html\n";
        print 'Content-Disposition: attachment; filename="cagefs-init.log"';
	my $filesize = -s CAGEFS_RESULTFILE;
        print "Content-Length: ".$filesize."\n\n";
	undef $/;
	open (FILE,CAGEFS_RESULTFILE);
	my $file = <FILE>;
	close(FILE);
	print "$file";
	exit;
}
}

Whostmgr::ACLS::init_acls();


# Check privileges
if ( !Whostmgr::ACLS::hasroot() ) {
    print "Content-type: text/html\n\n";

    defCustomHeader( 'CageFS', '/images/cagefs-32x32.png', '/cgi/addon_cagefs.cgi' );

    print qq{
<br />
<br />
<div align="center"><h1>Permission denied</h1></div>
};
    defFooter();
    exit;
}

my $theme = Whostmgr::Theme::gettheme();
my $self  = 'addon_cagefs.cgi';

if (!defined $FORM{'action'}){
	print "Content-type: text/html\n\n";


	if(!CheckSkeleteon()){
		defCustomHeader( 'CageFS Initialization Screen', '/images/cagefs-32x32.png', '/cgi/addon_cagefs.cgi' );
		print <<EOM;
<div id="MainContent">
    <br />
    <h3>CageFS is not initialized</h3>
    <a style="text-decoration:none;" href="addon_cagefs.cgi?action=Init"><input style="float:left; font-size:16px; text-decoration:none;" type="button" value="Init CageFS" /></a>
</div>
EOM
		defFooter();
		exit;
	}
	defCustomHeader( 'CageFS User Manager', '/images/cagefs-32x32.png', '/cgi/addon_cagefs.cgi' );

	if (CheckCagefsCtlExists() eq "update"){
		print qq{
			'<script>window.document.location.href = window.document.location.href+"?action=update_cagefs"</script>'
		};
		exit;
	}

	if (CheckCagefsCtlExists() eq "init"){
		print qq{
			'<script>window.document.location.href = window.document.location.href+"?action=Init"</script>'
		};
		exit;
	}

	if(!CheckCagefsMode()){
		printIndexJs();
		printAjaxJs();
		printCageFSDisabledHtml();
		defFooter();
		exit;


	}

	printIndexJs();
	printAjaxJs();
	if (CheckKernel() == 1) {
        printIndexHtml();
	} else {
        printCheckKernel();
	}
	defFooter();
	exit;
} else {
	if(defined $FORM{'action'}){
		my $cgiaction = $FORM{'action'};
		if ($cgiaction eq 'change_users_mode'){
			print "Content-type: text/html\n\n";
			ChangeUserMode($FORM{'mode'},$FORM{'users'});
			exit;
		}
		if ($cgiaction eq 'change_cagefs_mode'){
			print "Content-type: text/html\n\n";
			ChangeCageFSMode($FORM{'mode'});
			exit;
		}
		if ($cgiaction eq 'change_cagefs_status'){
			print "Content-type: text/html\n\n";
			ChangeCageFSStatus($FORM{'mode'});
			exit;
		}
		if ($cgiaction eq 'update_cagefs'){
			if(defined $FORM{'status'}){
				print "Content-type: text/html\n\n";
				print UpdateCageFS();
				exit;
			} else{
				if(defined $FORM{'refresh'}){
					print "Content-type: text/html\n\n";
					print UpdateCageFS();

					exit;
				} else {
					print "Content-type: text/html\n\n";

					defCustomHeader( 'CageFS Update Page', '/images/cagefs-32x32.png', '/cgi/addon_cagefs.cgi' );

					printIndexJs();
					printAjaxJs();
					printCageFSUpdateHtml();
					defFooter();
					exit;
				}
			}
		}
		if ($cgiaction eq 'Init'){
			if(defined $FORM{'status'}){
				print "Content-type: text/html\n\n";
				print InitCageFS();
				exit;
			} else {
				if(defined $FORM{'refresh'}){
					print "Content-type: text/html\n\n";
					print InitCageFS();

					exit;
				} else {
					print "Content-type: text/html\n\n";

					defCustomHeader( 'CageFS Init Page', '/images/cagefs-32x32.png', '/cgi/addon_cagefs.cgi' );

					printIndexJs();
					printAjaxJs();
					printCageFSInitHtml();
					defFooter();
					exit;
				}
			}
		}
		exit;
	}
}


print "Content-type: text/html\n\n";
print "<center>Unknown error</center>";
exit;

sub getCpanelVersion
{
	my $version = safeRun(
		'/usr/local/cpanel/cpanel -V'
	);
	(my $numOfVersion) = $version =~ /^(\d[\d\.]*)\s/;
	return $numOfVersion;
}

sub defFooter {
	if (getCpanelVersion() >= 64.0) {
		Whostmgr::HTMLInterface::deffooter();
	} else {
		print '</body></html>';
	}
}

sub CheckCagefsCtlExists {
    	my $result = safeRun('ps aux | grep cagefsctl');
   	my @values = split("\n",$result);
	foreach my $val (@values) {
    		if(index($val, "--init")!=-1){
			return "init";
		} elsif(index($val, "--reinit")!=-1){
			return "init";
		} elsif(index($val, "--update")!=-1){
			return "update";
		}
  	}
	return "none";
}

sub CheckSkeleteon {
	if (-e CAGEFS_SKELETON){
		if(-d CAGEFS_SKELETON){
			return 1;
		}
	}
	return 0;
}

sub CheckCagefsMode{
	my $result = safeRun('/usr/sbin/cagefsctl --display-user-mode');
	if(index($result, "CageFS is disabled")!=-1){
		return 0;
	} elsif (index($result, "Mode: Enable All")!=-1){
		return 1;
	} else {
		return 2;
	}
}

sub CheckKernel{
    my $test = safeRun('/usr/sbin/cagefsctl --check-kernel-version');
    if ($test.length == 0) {
        return 1;
    } else {
        return 2;
    }
}

sub getListEnabled{
	my $result1 = safeRun('/usr/sbin/cagefsctl --list-enabled');
	my @values1 = split("\n",$result1);
	if(index($result1,"CageFS is disabled")!=-1){
		return ();
	}
	splice(@values1, 0, 1);
	foreach (@values1) {
    		$_ = trim($_);
	}
	my @svalues1 = sort @values1;
	return @svalues1;
}

sub getListDisabled{
	my $result2 = safeRun('/usr/sbin/cagefsctl --list-disabled');
	my @values2 = split("\n",$result2);
	if(index($result2,"CageFS is disabled")!=-1){
		return ();
	}
	splice(@values2, 0, 1);
	foreach (@values2) {
    		$_ = trim($_);
	}
	my @svalues2 = sort @values2;
	return @svalues2;
}

sub printIndexJs{

	my @svalues1 = getListEnabled();
	my @svalues2 = getListDisabled();

	print <<EOM;

<script language="javascript">

    var DisableFilter = 0;
    var EnableFilter = 0;

    var enabled = new Array(
EOM
	my $sz = scalar (@svalues1);
	my $i=1;
	foreach my $val (@svalues1){
		if($sz>$i){
			print '"'.$val.'",';
		} else {
			print '"'.$val.'" ';
		}
		$i++;
	}

	print <<EOM;
    );

    var disabled = new Array(
EOM

	my $sz = scalar (@svalues2);
	my $i=1;
	foreach my $val (@svalues2){
		if($sz>$i){
			print '"'.$val.'",';
		} else {
			print '"'.$val.'" ';
		}
		$i++;
	}

	print <<EOM;
    );

    var DisabledSelected = Array();
    var EnabledSelected = Array();

    // Simple visualization
    function ChangeModeStart() {
        document.getElementById('ChangeUsersMode').style.display = 'none';
        document.getElementById('ChangeUsersProgress').style.display = 'block';
    }

    function ChangeModeEnd() {
        document.getElementById('ChangeUsersProgress').style.display = 'none';
        document.getElementById('ChangeUsersMode').style.display = 'block';
    }
    // End Simple visualization

    function DisabledFilter(str) {
        if (str.length >= 1) {
            DisableFilter = 1;
            for (i=0; i<disabled.length; i++) {
                if(disabled[i].toLowerCase().indexOf(str.toLowerCase()) + 1) {
                    DisabledSelected.push(disabled[i]);
                }
            }
            DisabledSelected.sort();
            document.getElementById('DisabledSelect').innerHTML = '';
            for (i=0; i<DisabledSelected.length; i++) {
                var elOptNew = document.createElement('option');
                    elOptNew.text = DisabledSelected[i];
                    elOptNew.value = DisabledSelected[i];
                try {
                    document.getElementById('DisabledSelect').add(elOptNew, null); // standards compliant; doesn't work in IE
                } catch(ex) {
                    document.getElementById('DisabledSelect').add(elOptNew); // IE only
                }
            }
        } else {
            if (DisableFilter) {
                DisableFilter = 0;
                document.getElementById('DisabledSelect').innerHTML = '';
                for (i=0; i<disabled.length; i++) {
                    var elOptNew = document.createElement('option');
                        elOptNew.text = disabled[i];
                        elOptNew.value = disabled[i];
                    try {
                        document.getElementById('DisabledSelect').add(elOptNew, null); // standards compliant; doesn't work in IE
                    } catch(ex) {
                        document.getElementById('DisabledSelect').add(elOptNew); // IE only
                    }
                }
            }
        }
        DisabledSelected = Array();
    }

    function EnabledFilter(str) {
        if (str.length >= 1) {
            EnableFilter = 1;
            for (i=0; i<enabled.length; i++) {
                if(enabled[i].toLowerCase().indexOf(str.toLowerCase()) + 1) {
                    EnabledSelected.push(enabled[i]);
                }
            }
            EnabledSelected.sort();
            document.getElementById('EnabledSelect').innerHTML = '';
            for (i=0; i<EnabledSelected.length; i++) {
                var elOptNew = document.createElement('option');
                    elOptNew.text = EnabledSelected[i];
                    elOptNew.value = EnabledSelected[i];
                try {
                    document.getElementById('EnabledSelect').add(elOptNew, null); // standards compliant; doesn't work in IE
                } catch(ex) {
                    document.getElementById('EnabledSelect').add(elOptNew); // IE only
                }
            }
        } else {
            if (EnableFilter) {
                EnableFilter = 0;
                document.getElementById('EnabledSelect').innerHTML = '';
                for (i=0; i<enabled.length; i++) {
                    var elOptNew = document.createElement('option');
                        elOptNew.text = enabled[i];
                        elOptNew.value = enabled[i];
                    try {
                        document.getElementById('EnabledSelect').add(elOptNew, null); // standards compliant; doesn't work in IE
                    } catch(ex) {
                        document.getElementById('EnabledSelect').add(elOptNew); // IE only
                    }
                }
            }
        }
        EnabledSelected = Array();
    }

    function moveEnabled() {
        users_list = '';
        for(i=0; i<document.getElementById('EnabledSelect').options.length; i++)
        {
            if (document.getElementById('EnabledSelect').options[i].selected == true) {
                disabled.push(document.getElementById('EnabledSelect').options[i].value);
                for (j=0; j<enabled.length; j++) {
                    if(enabled[j].toLowerCase().indexOf(document.getElementById('EnabledSelect').options[i].value.toLowerCase()) + 1) {
                        enabled.splice(j,1);
                    }
                }
                users_list = users_list + document.getElementById('EnabledSelect').options[i].value + '|';
            }
        }

        disabled.sort();
        enabled.sort();

        rebuildSelectBoxes();

        return users_list;
    }

    function moveDisabled() {
        users_list = '';
        for(i=0; i<document.getElementById('DisabledSelect').options.length; i++)
        {
            if (document.getElementById('DisabledSelect').options[i].selected == true) {
                enabled.push(document.getElementById('DisabledSelect').options[i].value);
                for (j=0; j<disabled.length; j++) {
                    if(disabled[j].toLowerCase().indexOf(document.getElementById('DisabledSelect').options[i].value.toLowerCase()) + 1) {
                        disabled.splice(j,1);
                    }
                }
                users_list = users_list + document.getElementById('DisabledSelect').options[i].value + '|';
            }
        }

        disabled.sort();
        enabled.sort();

        rebuildSelectBoxes();

        return users_list;
    }

    function rebuildSelectBoxes() {

        document.getElementById('EnabledUsers').innerHTML = enabled.length;
        document.getElementById('DisabledUsers').innerHTML = disabled.length;

        document.getElementById('DisabledSelect').innerHTML = '';
        for (i=0; i<disabled.length; i++) {
            var elOptNew = document.createElement('option');
                elOptNew.text = disabled[i];
                elOptNew.value = disabled[i];
            try {
                document.getElementById('DisabledSelect').add(elOptNew, null); // standards compliant; doesn't work in IE
            } catch(ex) {
                document.getElementById('DisabledSelect').add(elOptNew); // IE only
            }
        }

        document.getElementById('EnabledSelect').innerHTML = '';
        for (i=0; i<enabled.length; i++) {
            var elOptNew = document.createElement('option');
                elOptNew.text = enabled[i];
                elOptNew.value = enabled[i];
            try {
                document.getElementById('EnabledSelect').add(elOptNew, null); // standards compliant; doesn't work in IE
            } catch(ex) {
                document.getElementById('EnabledSelect').add(elOptNew); // IE only
            }
        }

        document.getElementById('DisabledFilter').value = '';
        document.getElementById('EnabledFilter').value = '';
    }

    function change(status, ajax_url) {
        if (status == 'Disable All') {
            if (confirm("Do you want new users not to be in CageFS?")) {
                document.getElementById('MainContent').style.display = 'none';
                document.getElementById('ChangeCageFSMode').style.display = 'block';
                ajax(ajax_url,'ajax_container','Reload');
            }
        } else {
            if (confirm("Do you want new users to be in CageFS?")) {
                document.getElementById('MainContent').style.display = 'none';
                document.getElementById('ChangeCageFSMode').style.display = 'block';
                ajax(ajax_url,'ajax_container','Reload');
            }
        }
    }

    function DisableCageFS(status,ajax_url) {
        if ('enabled' == status)
            if (confirm("Do you want disable CageFS?")) {
                document.getElementById('MainContent').style.display = 'none';
                document.getElementById('ChangeCageFSStatus').style.display = 'block';
                ajax(ajax_url,'ajax_container','Reload');
            }
        if ('disabled' == status) {
            if (confirm("Do you want enable CageFS?")) {
                document.getElementById('MainContent').style.display = 'none';
                document.getElementById('ChangeCageFSStatus').style.display = 'block';
                ajax(ajax_url,'ajax_container','Reload');
            }
        }
    }

    function UpdateCageFS(url) {
        if (confirm("Do you want to update CageFS Skeleton?")) {
            return true;
        } else {
            return false;
        }
    }
</script>

EOM

}

sub printAjaxJs{
	print <<EOM;

<script language="javascript">
    function ajax( ajax_resource, ajax_container, after_reload, parameters){
    	//document.getElementById( ajax_container ).innerHTML = "<h2 style='color:#FF0000'>Loading</h2>";
    	document.cookie = "ajax_resource=" + ajax_resource;
    	document.cookie = "ajax_container=" + ajax_container;
    	try {
    		var RequestXmlHttp = new XMLHttpRequest();
    	}
    	catch( e ) {
    		var XmlHttpVersions = new Array( "MSXML2.XMLHTTP.6.0",
    													"MSXML2.XMLHTTP.5.0",
    													"MSXML2.XMLHTTP.4.0",
    													"MSXML2.XMLHTTP.3.0",
    													"MSXML2.XMLHTTP",
    													"Microsoft.XMLHTTP" );
    		for ( var i = 0; i < XmlHttpVersions.length && !RequestXmlHttp; i++ ) {
    			try {
    				var RequestXmlHttp = new ActiveXObject( XmlHttpVersions[i] );
    			}
    			catch ( e ) { }
    		}
    	}
    	if ( !RequestXmlHttp ) {
    		alert('Your browser don\\'t support Ajax. Please enable JAVASRCRIPT for correct work.');
    	}
    	else {
    		url = ajax_resource;
    		if ( parameters ) url += "?" + parameters;
    		//alert(url);
    		RequestXmlHttp.open( "GET", url, true );
    		RequestXmlHttp.onreadystatechange = function() {
    			// if xmlhttp shows "loaded"
    			if ( RequestXmlHttp.readyState == 4 ) {
    				// if "OK"
    				if ( RequestXmlHttp.status == 200 ) {
//alert(RequestXmlHttp.responseText);
    					document.getElementById( ajax_container ).innerHTML = RequestXmlHttp.responseText;
    					if (after_reload == 'ChangeModeEnd')
    					{
    						ChangeModeEnd();
    					}
    					if (after_reload == 'Reload') {
    					    window.document.location.reload();
    					}
    					if (after_reload == 'Join') {
                            Progress();
    					}
    					// ...some code here...
    				}
    				else {
    //					alert( "Ошибка получения данных" );
    				}
    			}
    		}
    		RequestXmlHttp.send( null );
    	}
    }
</script>

EOM

}

sub trim($)
{
	my $string = shift;
	$string =~ s/^\s+//;
	$string =~ s/\s+$//;
	return $string;
}

sub printCheckKernel{
    print <<EOM;
    <div id="MainContent">
        Current running kernel is NOT supported.
    </div>
EOM
}

sub printIndexHtml{
	my @svalues1 = getListEnabled();
	my @svalues2 = getListDisabled();

	print <<EOM;

<div id="MainContent">
    <div style="max-width:577px">
        <p style="font-weight:bold;">CageFS user interface is now part of CloudLinux LVE Manager. The plugin version will soon be deprecated.</p>
        <p>Take a note that the configuration of CageFS for users is located at the Users tab in the main menu of LVE Manager and the global CageFS settings (Toggle, update skeleton and others) are located at the Options tab in the main menu of LVE Manager inside the section "CageFs".</p>
        <hr/><br/>
    </div>
    <!--<h3>CageFS User Manager:</h3>-->
    New users will be
EOM
	my $md=CheckCagefsMode();
	my $rs = "";
	my $st = "";
	if($md==1){
		print "enabled";
		$rs = "Disable All";
		$st = "enable all"
	} else {
		print "disabled";
		$rs = "Enable All";
		$st = "disable all";
	}
	my $cnt1 = scalar grep { defined $_ } @svalues1;
	my $cnt2 = scalar grep { defined $_ } @svalues2;
	print <<EOM;
 by default in CageFS
    <a style="text-decoration:none;" href="addon_cagefs.cgi?action=change_cagefs_mode" onclick="change('$rs', this.href+'&mode=$st'); return false;"><input type="button" style="margin-left:20px; font-size:16px;" value="Toggle" /></a>
    <br /><br /><br />
    <table border="0" cellpadding="4" cellspacing="0">
        <tr valign="top">
            <td>
                Enabled Users (<span id="EnabledUsers">$cnt1</span>)<br />
                <input type="text" style="width:198px;" onkeyup="EnabledFilter(this.value)" id="EnabledFilter" /><br />
                <select id="EnabledSelect" multiple size="10" style="width:200px;">
EOM
	foreach my $val (@svalues1){
		print '<option id="'.$val.'" value="'.$val.'">'.$val.'</option>';
	}

	print <<EOM;
                </select>
            </td>
            <td align="center" style="padding-left:50px; padding-top:70px; font-size:20px">
                <div id="ChangeUsersMode">
                    <a style="margin-left:5px; text-decoration:none;" href="addon_cagefs.cgi?action=change_users_mode" onclick="ChangeModeStart(); ajax(this.href+'&mode=enable&users='+moveDisabled(),'ajax_container', 'ChangeModeEnd'); return false;"><input style="font-size:30px; text-decoration:none;" type="button" value="<<" /></a>
                        <br /><br />
                    <a style="text-decoration:none;" href="addon_cagefs.cgi?action=change_users_mode" onclick="ChangeModeStart(); ajax(this.href+'&mode=disabled&users='+moveEnabled(),'ajax_container', 'ChangeModeEnd'); return false;"><input style="font-size:30px; text-decoration:none;" type="button" value=">>" /></a>
                </div>
                <div id="ChangeUsersProgress" style="display:none; padding-top:20px;">
                    <img src="cageFS/progress_bar.gif" />
                </div>
            </td>
            <td style="padding-left:50px">
                Disabled Users (<span id="DisabledUsers">$cnt2</span>)<br />
                <input type="text" style="width:198px;" onkeyup="DisabledFilter(this.value)" id="DisabledFilter" /><br />
                <select id="DisabledSelect" multiple size="10" style="width:200px;">
EOM
	foreach my $val (@svalues2){
		print '<option id="'.$val.'" value="'.$val.'">'.$val.'</option>';
	}

	print <<EOM;
                </select>
            </td>
        </tr>
        <tr>
            <td colspan="3">
                <br />
                <hr />
                <br />
            </td>
        </tr>
        <tr valign="top">
            <td style="padding-bottom:50px;">
                <a style="text-decoration:none;" href="addon_cagefs.cgi?action=change_cagefs_status" onclick="DisableCageFS('enabled', this.href+'&mode=disable'); return false;"><input style="float:left; font-size:16px; text-decoration:none;" type="button" value="Disable CageFS" /></a>
            </td>
            <td></td>
            <td>
                <a style="text-decoration:none;" href="addon_cagefs.cgi?action=update_cagefs" onclick="return UpdateCageFS(this.href);"><input style="float:right; font-size:16px" type="button" value="Update CageFS Skeleton" /></a>
            </td>
        </tr>
    </table>
</div>
<div id="ajax_container"></div>
<div id="ChangeCageFSMode" style="display:none; margin-top:150px;" align="center">
    <img src="cageFS/loading_bar.gif" /> Changing CageFS mode
</div>
<div id="ChangeCageFSStatus" style="display:none; margin-top:150px;" align="center">
    <img src="cageFS/loading_bar.gif" /> Changing CageFS Status
</div>

EOM
}

sub printCageFSDisabledHtml{
	print <<EOM;

<div id="MainContent">
    <br />
    <h3>CageFS is currently Disabled</h3>
    <a style="text-decoration:none;" href="addon_cagefs.cgi?action=change_cagefs_status" onclick="DisableCageFS('disabled', this.href+'&mode=enable'); return false;"><input style="float:left; font-size:16px; text-decoration:none;" type="button" value="Enable CageFS" /></a>
</div>
<div id="ChangeCageFSStatus" style="display:none; margin-top:150px;" align="center">
    <img src="cageFS/loading_bar.gif" /> Changing CageFS Status
</div>
<div id="ajax_container"></div>

EOM
}

sub ChangeUserMode{
	my ($mode, $users ) = @_;
	if(trim($users) ne ""){
		my @usrs = split '\|', $users;
		my $new_users = "";
		foreach my $val (@usrs){
			if(trim($val) ne "") {
				$new_users=$new_users.$val." ";
			}
		}
		if($mode eq "enable"){
			safeRun('/usr/sbin/cagefsctl --enable '.$new_users);
		}
		if($mode eq "disabled"){
			safeRun('/usr/sbin/cagefsctl --disable '.$new_users);
		}
	}
}

sub ChangeCageFSMode{
	my ($mode) = @_;
	if ($mode eq 'disabled'){
		safeRun('/usr/sbin/cagefsctl --toggle-mode');
	} else {
		safeRun('/usr/sbin/cagefsctl --toggle-mode');
	}
}

sub ChangeCageFSStatus{
	my ($action) = @_;
	if ($action eq 'disable'){
		safeRun('/usr/sbin/cagefsctl --disable-cagefs');
	} else {
		safeRun('/usr/sbin/cagefsctl --enable-cagefs');
	}
}

sub UpdateCageFS{
	if (!CheckSkeleteon()){
		return "";
	}
	my $res = CheckCagefsCtlExists();

	if(defined $FORM{'status'}){
		if($res eq 'update'){
			return "";
		} else {
			return "end";
		}
	}

	if(($res ne 'update')&&($FORM{'action'} eq 'update_cagefs')&&(!defined $FORM{'refresh'})){
		safeRun('/usr/sbin/cagefsctl --update --do-not-ask --silent &>/dev/null &');
		return "";
	}

	if($res eq 'none'){
		my $Out = "";
		my @strs = tail();
		foreach my $val (@strs){
			$Out = $Out.$val.'<br />';
		}
		$Out = $Out.'<br /><b>Update complete</b>';
                return $Out;
	}

	if($res eq 'update'){
		my $Out = "";
		my @strs = tail();
		foreach my $val (@strs){
			$Out = $Out.$val.'<br />';
		}
                return $Out;
	}

	return "";
}

sub tail {
    my $lim = 100;

    my @alpha;
    my @beta;
    my $current = \@alpha;

    open( IN, CAGEFS_RESULTFILEUPD ) or die "Cannot open " .CAGEFS_RESULTFILEUPD. " for input: $!\n";
    while( <IN> ) {
        push @$current, $_;
        if( scalar @$current > $lim ) {
            if( $current == \@alpha ) {
                @beta = ();
                $current = \@beta;
            }
            else {
                @alpha = ();
                $current = \@alpha;
            }
        }
    }
    close IN;

    return @{$current == \@alpha ? \@beta : \@alpha}[-($lim - scalar @$current)..-1],
        @$current;
}

sub printCageFSUpdateHtml{
	print <<EOM;
<script language="javascript">
    function Progress() {
        document.getElementById('UpdateProgress').scrollTop = document.getElementById('UpdateProgress').scrollHeight;
        setTimeout(function(){GetUpdateStatus()}, 5000);
    }

    function BackToManager(){
	window.document.location.href = "addon_cagefs.cgi";
	return true;
    }

    function GetUpdateStatus() {
        str = document.getElementById('Status').innerHTML;
        if (str.indexOf('end')+1) {
            UpdateComplete();
        } else {
            ajax(window.document.location+'&status=true','Status');
            ajax(window.document.location+'&refresh=true','UpdateProgress','Join');
        }
    }

    function UpdateComplete() {
       document.getElementById('ProgressBar').innerHTML = 'CageFS was updated. See bellow for more information<br />';
       document.getElementById('ProgressBar').innerHTML = document.getElementById('ProgressBar').innerHTML + '<a href="addon_cagefs.cgi?action=get_update_log" target="_blank">Download Update Log</a>'+ '<br/><br/><a href="addon_cagefs.cgi">Back to CageFS User manager</a>';
       document.getElementById('UpdateProgress').scrollTop = document.getElementById('UpdateProgress').scrollHeight;
    }
</script>
<div id="MainContent">
    <br />
    <!--<h3>CageFS Update Page:</h3>-->
    <div id="ProgressBar">
        <img src="cageFS/loading_bar.gif" /> Updating Skeleton</div>
    <br />
    <div id="UpdateProgress" style="width:80%; border: 1px solid #000000; height:400px; overflow-y: auto; font-size:14px;">
EOM
	my $Progress = UpdateCageFS();
	print $Progress;
print <<EOM;
    <script>Progress();</script>
    </div>
    <div id="Status" style="display:none;"></div>
</div>
EOM
}

sub InitCageFS{

	my $res = CheckCagefsCtlExists();

	if(defined $FORM{'status'}){
		if($res eq 'init'){
			return "";
		} else {
			return "end";
		}
	}

	if(($res ne 'init')&&($FORM{'action'} eq 'Init')&&(!defined $FORM{'refresh'})){
		safeRun('/usr/sbin/cagefsctl --init --do-not-ask --silent &>/dev/null &');
		return "";
	}

	if($res eq 'none'){
		my $Out = "";
		my @strs = tail();
		foreach my $val (@strs){
			$Out = $Out.$val.'<br />';
		}
		$Out = $Out.'<br /><b>Init complete</b>';
                return $Out;
	}

	if($res eq 'init'){
		my $Out = "";
		my @strs = tail();
		foreach my $val (@strs){
			$Out = $Out.$val.'<br />';
		}
                return $Out;
	}

	return "";
}

sub printCageFSInitHtml{

print <<EOM;
<script language="javascript">
    function Progress() {
        document.getElementById('InitProgress').scrollTop = document.getElementById('InitProgress').scrollHeight;
        setTimeout(function(){GetUpdateStatus()}, 5000);
    }

    function BackToManager(){
	window.document.location.href = "addon_cagefs.cgi";
	return true;
    }


    function GetUpdateStatus() {
        str = document.getElementById('Status').innerHTML;
        if (str.indexOf('end')+1) {
            UpdateComplete();
        } else {
            ajax(window.document.location+'&status=true','Status');
            ajax(window.document.location+'&refresh=true','InitProgress','Join');
        }
    }

    function UpdateComplete() {
       document.getElementById('ProgressBar').innerHTML = 'CageFS was Initialized. See bellow for more information<br />';
       document.getElementById('ProgressBar').innerHTML = document.getElementById('ProgressBar').innerHTML + '<a href="addon_cagefs.cgi?action=get_init_log" target="_blank">Download Init Log</a>'+ '<br/><br/><a href="addon_cagefs.cgi">Continue...</a>';
       document.getElementById('InitProgress').scrollTop = document.getElementById('InitProgress').scrollHeight;
    }
</script>
<div id="MainContent">
    <br />
    <!--<h3>CageFS Init Page:</h3>-->
    <div id="ProgressBar">
        <img src="cageFS/loading_bar.gif" /> Init Skeleton</div>
    <br />
    <div id="InitProgress" style="width:80%; border: 1px solid #000000; height:400px; overflow-y: auto; font-size:14px;">
EOM
	my $Progress = InitCageFS();
	print $Progress;
print <<EOM;
    <script>Progress();</script>
    </div>
    <div id="Status" style="display:none;"></div>
</div>
EOM

}

sub defCustomHeader {
    Cpanel::Template::process_template(
        'whostmgr',
        {
            'print'                        => 1,
            'template_file'                => '_defheader.tmpl',
            'header'                       => $_[0] || undef,
            'icon'                         => $_[1] || undef,
            'theme'                        => "yui",
            'breadcrumbdata'               => {
                'name' => $_[0],
                'url' => $_[2],
                'previous' => [
                    {
                        'name' => 'Home',
                        'url' => '/scripts/command?PFILE=main'
                    },
                    {
                        'name' => 'Plugins',
                        'url'  => '/scripts/command?PFILE=Plugins'
                    }
                ]
            }
        },
    );

    return;
}

sub safeRun {
    my @params = join ' ', @_;
    unshift @params, '/bin/sh', '-c';
    Cpanel::SafeRun::Errors::saferunallerrors(@params);
}