#!/bin/bash
# CageFS script to patch and rebuild suphp

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

. /opt/alt/python37/usr/share/python-cllib/scripts/cl-common
common_path_of_cpanel="/usr/share/cagefs/cpanel"

#if [ -z "$1" ]
#then
#    MIN_UID=500
#else
#    MIN_UID=$1
#fi

ROOT_UID=0

if [ "$UID" -ne "$ROOT_UID" ]
then
  echo "ERROR: root privileges required"
  exit
fi

if is_ea4; then
    writeToLog "[CageFS] EasyApache 4 is active. Skip rebuilding suphp" "$common_path_of_cpanel"
    exit 0
fi

writeToLog "[CageFS] rebuild suphp" "$common_path_of_cpanel"

	# patch suphp
	log=$(getLogFile "$common_path_of_cpanel")
	easyApacheDir=$(getEasyApacheDir)
	currentpath=$(pwd)
	cd $common_path_of_cpanel

suphp_source_found=0

	if [ -e "suphp-0.7.1-cagefs.patch" ];then
	    cd $easyApacheDir/src
	    for dirname in ./suphp*; do
		if [ -d "$dirname/src" ];then
                suphp_source_found=1
                echo $dirname >>$log
				cd $dirname/src
                if [ "$2" == "restore" ]; then
					# apply patch if it has not been applied yet
    		        patch -N -i $common_path_of_cpanel/suphp-0.7.1-cagefs.patch >/dev/null
    		        patch -R -N -i $common_path_of_cpanel/suphp-0.7.1-cagefs.patch 1>>$log 2>>$log
                else
					# reverse patch if it is already applied
    		        patch -R -N -i $common_path_of_cpanel/suphp-0.7.1-cagefs.patch >/dev/null
    		        patch -N -i $common_path_of_cpanel/suphp-0.7.1-cagefs.patch 1>>$log 2>>$log
                fi
    		    if [ $? != 0 ];then
        			echo "Error applying patch. Please, contact support at http://www.cloudlinux.com/support/" >>$log
        			cd $currentpath
        			exit 1
    		    else 
        			echo "Patch was applied correctly..." >>$log
    		    fi

				cd ..

				if [ "$1" == "1" ]; then
					# ./configure 1>>$log 2>/dev/null
					if [ -e "/usr/local/apache/bin/apr-1-config" ]; then
					./configure  --with-apr=/usr/local/apache/bin/apr-1-config --with-apxs=/usr/local/apache/bin/apxs --prefix=/opt/suphp 1>>$log 2>>$log
					else
					./configure  --with-apr=/usr/local/apache/bin/apr-config --with-apxs=/usr/local/apache/bin/apxs --prefix=/opt/suphp 1>>$log 2>>$log
					fi
				fi

				make 1>>$log 2>>$log
				if [ $? != 0 ];then
        			echo "Error while building suphp. Please, contact support at http://www.cloudlinux.com/support/"
        			cd $currentpath
        			exit 1
				fi

			if [ "$2" != "restore" ]; then
                # check that suphp is correct
                if grep lve_jail ./src/suphp 1>>$log 2>>$log 1>>$log 2>>$log ; then
                    # install suphp

					make install 1>>$log 2>>$log
					if [ $? != 0 ];then
        				echo "Error while installing suphp. Please, contact support at http://www.cloudlinux.com/support/"
        				cd $currentpath
        				exit 1
					fi

                    break
                else
                    echo "Error while rebuilding suphp"
                    echo "Please, try to rebuild suphp manually"
                    echo "If you use CPanel, you should run:"
                    echo "/scripts/upcp --force"
                    echo "/scripts/easyapache"
                    echo ""
                    cd $currentpath
                    exit 1
                fi
			else
					make install 1>>$log 2>>$log
					if [ $? != 0 ];then
        				echo "Error while installing suphp. Please, contact support at http://www.cloudlinux.com/support/"
        				cd $currentpath
        				exit 1
					fi
			fi

                cd $easyApacheDir/src
		fi
	    done
	else
	    echo "Cannot find suphp-0.7.1-cagefs.patch. Contact support at http://www.cloudlinux.com/support/" >>$log
	    cd $currentpath
	    exit 1
	fi

	if [ $suphp_source_found -eq 0 ]; then
                    echo "Error: suphp source is NOT found"
                    echo "Please, try to rebuild suphp manually"
                    echo "If you use CPanel, you should run:"
                    echo "/scripts/upcp --force"
                    echo "/scripts/easyapache"
                    echo ""
                    exit 1
	fi

	# restart Apache
	/scripts/restartsrv_httpd

	cd $currentpath

writeToLog "[CageFS] suphp was rebuilt successfully" "$common_path_of_cpanel"
