# CageFS post modify admin hooks
# -*- coding: utf-8 -*-

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

from __future__ import print_function
from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals
from future import standard_library
standard_library.install_aliases()
from builtins import *

from clcommon.public_hooks.lib import ModifyAdminHook
from clsudo import Clsudo


class CagefsSudoersHook(ModifyAdminHook):
    """
    Listener that automatically manages /etc/sudoers
    by control panel hooks.
    """

    def post_create_admin(self, name, **kwargs):
        Clsudo().add_cagefs_user(name)

    def post_delete_admin(self, name, **kwargs):
        Clsudo().remove_user(name)
