# CageFS post modify admin hooks
# -*- coding: utf-8 -*-

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

from __future__ import print_function
from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals
from future import standard_library
standard_library.install_aliases()
from builtins import *
import sys

from clcommon.public_hooks.lib import ModifyAdminHook, ModifyUserHook, ModifyDomainHook

# CageFS imports
sys.path.append('/usr/share/cagefs')        # noqa
import generic_hook_lib


class CagefsHook(ModifyUserHook, ModifyAdminHook, ModifyDomainHook):

    def post_create_admin(self, admin_name, **kwargs):
        """
        Triggered after creating new admin.
        :param admin_name: admin name
        """
        print(generic_hook_lib.post_create_admin_handler(admin_name))

    def post_delete_admin(self, admin_name, **kwargs):
        """
        Triggered after removing admin.
        :param admin_name: admin name
        """
        print(generic_hook_lib.post_delete_admin_handler(admin_name))

    def post_create_user(self, username, owner, **kwargs):
        """
        Triggered after creating new user.
        :param username: account name
        :param owner: Reseller's name
        """
        print(generic_hook_lib.post_create_user_handler(username))

    # pylint: disable=unused-argument
    def post_modify_user(self, username, new_name=None, new_owner=None, **kwargs):
        """
        Triggered any user modification
        :param username: account name before rename
        :param new_name: account name after rename
        """
        print(generic_hook_lib.post_modify_user_handler(
            username, new_name=new_name, new_owner=new_owner))

    def post_create_domain(self, username, domain):
        """
        Triggered after creating additional domains in control panel.
        :param username: owner of the domain
        :param domain: name of the domain
        """
        print(generic_hook_lib.post_create_domain_handler(username, domain))

    def post_restore_user(self, username, **kwargs):
        """
        Triggered after restoring user.
        :param username: account name
        """
        print(generic_hook_lib.post_restore_user_handler(username))

    def post_delete_domain(self, username, domain):
        """
        Triggered after deleting domain owned by system account.
        :param username: account name
        :param domain: domain name
        """
        print(generic_hook_lib.post_delete_domain_handler(username, domain))

    def pre_delete_user(self, username, **kwargs):
        """
        Triggered before removing user.
        :param username: account name
        """
        print(generic_hook_lib.pre_delete_user_handler(username))

    def post_modify_domain(self, username, domain, new_domain=None, include_subdomains=None, **kwargs):
        """
        Triggered after any domain change.
        :param username: owner of the domain
        :param domain: name before rename
        :param new_domain: name after rename [optional]
        :param include_subdomains: whether subdomains are renamed too [optional]
        :param kwargs: any other args
        """
        print(generic_hook_lib.post_modify_domain_handler(username, domain))
