#!/opt/alt/python37/bin/python3.7 -bb
# coding:utf-8

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT
from __future__ import absolute_import
from __future__ import division
from __future__ import print_function
import sys

from clcommon.public_hooks.bundle import cpanel
from clcommon.public_hooks import setup_logger_and_sentry


_BASE_DIR = '/usr/share/cagefs/cpanel/'
_HOOKS = [
    cpanel.Hook(
        _BASE_DIR + 'rearrange_hook.py',
        'Whostmgr', 'Accounts::rearrangeacct',               'post'),
    cpanel.Hook(
        _BASE_DIR + 'cpanel_multiphp_hook.py',
        'Whostmgr', 'Lang::PHP::set_system_default_version', 'post'),
    cpanel.Hook(
        _BASE_DIR + 'cpanel_multiphp_hook.py',
        'Whostmgr', 'Lang::PHP::ini_set_content',            'post'),
    cpanel.Hook(
        _BASE_DIR + 'cpanel_multiphp_hook.py',
        'Whostmgr', 'Lang::PHP::ini_set_directives',         'post'),
]


def main(argv):
    """
    Install or delete cpanel event hook
    """
    if "-i" in argv:
        success = cpanel.install_hooks(_HOOKS)

    elif "-d" in argv:
        success = cpanel.remove_hooks(_HOOKS)

    else:
        raise NotImplementedError('unknown option')

    return int(not success)


if "__main__" == __name__:
    # in fact this is only wrapper for
    # hooks logic located in cllib
    # so we can just use cllib sentry here
    setup_logger_and_sentry()
    sys.exit(main(sys.argv[1:]))
