#!/bin/bash
# CageFS script to patch and rebuild suphp

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

. /opt/alt/python37/usr/share/python-cllib/scripts/cl-common
common_path_of_cpanel="/usr/share/cagefs/cpanel"

ROOT_UID=0

if [ "$UID" -ne "$ROOT_UID" ]
then
  echo "ERROR: root privileges required"
  exit
fi

if is_ea4; then
    writeToLog "[CageFS] EasyApache 4 is active. Skip patching suphp" "$common_path_of_cpanel"
    exit 0
fi

if ! /usr/bin/cldetect --cpanel-suphp-enabled; then
    writeToLog "[CageFS] SuPHP is disabled. Skip patching suphp" "$common_path_of_cpanel"
    exit 0
fi

writeToLog "[CageFS] patch suphp" "$common_path_of_cpanel"

        # patch suphp
        log=$(getLogFile "$common_path_of_cpanel")
        easyApacheDir=$(getEasyApacheDir)
        currentpath=$(pwd)
        cd $common_path_of_cpanel

suphp_source_found=0

        if [ -e "suphp-0.7.1-cagefs.patch" ];then
            cd $easyApacheDir/src
            for dirname in ./suphp*; do
                if [ -d "$dirname/src" ];then
                suphp_source_found=1
                echo $dirname >>$log
                                cd $dirname/src
                        patch -R -N -i $common_path_of_cpanel/suphp-0.7.1-cagefs.patch >/dev/null
                        patch -N -i $common_path_of_cpanel/suphp-0.7.1-cagefs.patch 1>>$log 2>>$log
                    if [ $? != 0 ];then
                                echo "Error applying patch. Please, contact support at http://www.cloudlinux.com/support/" >>$log
                                cd $currentpath
                                exit 1
                    else
                                echo "Patch was applied correctly..." >>$log
                    fi

                    break
                else
                    echo "Error while rebuilding suphp"
                    echo "Please, try to rebuild suphp manually"
                    echo "If you use CPanel, you should run:"
                    echo "/scripts/upcp --force"
                    echo "/scripts/easyapache"
                    echo ""
                    cd $currentpath
                    exit 1
                fi

                cd $easyApacheDir/src
            done
        else
            echo "Cannot find suphp-0.7.1-cagefs.patch. Contact support at http://www.cloudlinux.com/support/" >>$log
            cd $currentpath
            exit 1
        fi

        if [ $suphp_source_found -eq 0 ]; then
                    echo "Error: suphp source is NOT found"
                    echo "Please, try to rebuild suphp manually"
                    echo "If you use CPanel, you should run:"
                    echo "/scripts/upcp --force"
                    echo "/scripts/easyapache"
                    echo ""
                    exit 1
        fi

        cd $currentpath

writeToLog "[CageFS] suphp was patched successfully" "$common_path_of_cpanel"
