#!/bin/bash

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT
# CageFS hook to patch Apache's suexec

. /opt/alt/python37/usr/share/python-cllib/scripts/cl-common
common_path_of_cpanel="/usr/share/cagefs/cpanel"

if is_ea4; then
    writeToLog "[CageFS] EasyApache 4 is active. Skip patching suexec" "$common_path_of_cpanel"
    exit 0
fi


writeToLog "[CageFS] apply patch for suexec" "$common_path_of_cpanel"

	# patch apache's suexec
	log=`getLogFile "$common_path_of_cpanel"`
	currentpath=$(pwd)
	cd $common_path_of_cpanel

	if [ -e "httpd2-cagefs_jail.patch" ];then
	    cd /home/cpeasyapache/src
	    for dirname in ./httpd*; do
		if [ -d "$dirname/support" ];then
                echo $dirname >>$log
				cd $dirname/support
    		    patch -N -i $common_path_of_cpanel/apache-cagefs.patch >>$log
    		    patch -N -i $common_path_of_cpanel/httpd2-cagefs_jail.patch >>$log
    		    if [ $? != 0 ];then
        			echo "Error applying patch. Please, contact support at http://www.cloudlinux.com/support/" >>$log
        			cd $currentpath
        			exit 1
    		    else 
        			echo "Patch was applied correctly..." >>$log
    		    fi
    		    cd - 
		fi
	    done
	else
	    echo "Cannot find httpd2-cagefs_jail.patch. Contact support at http://www.cloudlinux.com/support/" >>$log
	    cd $currentpath
	    exit 1
	fi

	cd $currentpath


writeToLog "[CageFS] suexec was patched successfully" "$common_path_of_cpanel"

