<?php
/**
 * Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
 *
 * Licensed under CLOUD LINUX LICENSE AGREEMENT
 * http://cloudlinux.com/docs/LICENSE.TXT
 */
require_once('modules/pm.php');
require_once('modules/plesk-cagefs/config.php');

function check_referer() {
    if ( empty($_SERVER['HTTP_REFERER']) ) {
        return false;
    }
    $referer_url_parsed = parse_url($_SERVER['HTTP_REFERER']);
    $host_url = get_schema().$_SERVER['HTTP_HOST'];
    $referer_url = $referer_url_parsed['scheme'].'://'.$referer_url_parsed['host'];
    if ( !empty($referer_url_parsed['port']) ) {
        $referer_url .= ':'.$referer_url_parsed['port'];
    }
    return $host_url == $referer_url;
};

function get_schema() {
    if(isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == "on") {
        return 'https://';
    } else {
        return 'http://';
    }
}
// Setup token
if ( !array_key_exists(PROTECT_URL_KEY, $_GET) && !array_key_exists(PROTECT_URL_KEY, $_GET) ) {
    if ( check_referer() ) {
        $default_url = get_schema()."$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
        if ( parse_url($default_url, PHP_URL_QUERY) ) {
            $default_url .= '&'.PROTECT_URL;
        } else {
            $default_url .= '?'.PROTECT_URL;
        }
        echo "<html><head><meta http-equiv='refresh' content='0;url=$default_url'></head><body>Setup security token...</body></html>";
        die();
    } else {
        print "bad referer {$_SERVER['HTTP_REFERER']}"; print "<br>";
        die();
    }
}



if ( $_GET[PROTECT_URL_KEY] != PROTECT_URL_VAL && $_POST[PROTECT_URL_KEY] != PROTECT_URL_VAL ) {
    print "bad forgery_protection_token"; print "<br>";
    die();
}