<?php
/**
 * Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
 *
 * Licensed under CLOUD LINUX LICENSE AGREEMENT
 * http://cloudlinux.com/docs/LICENSE.TXT
 */
require_once ('modules/plesk-cagefs/options.php');

class InitPage
{
  private $module_pointer;

  public function _construct ($ptr)
  {
    $module_pointer = $ptr;
  }

  public function getResult ($vars)
  {
    $ovars = $vars;
    $isAction = checkForCageFSCtlExists ();
    $ovars["CAGEFS_BUTTON_INIT"] = "";
    $ovars["CAGEFS_RESULT_INIT"] = "";
    $ovars["CAGEFS_NORERESH_INIT"] = "";
    $ovars["CAGEFS_BACK"]="";

    if (isset ($_POST["init_action"]) && ($isAction["action"] == "none"))
      {
	if (file_exists (CAGEFS_RESULTFILE))
	  {
	    unlink (CAGEFS_RESULTFILE);
	  }
	if (checkForSkeleteon ())
	  {
	    $command =
	      "/usr/bin/sudo /usr/sbin/cagefsctl --reinit --do-not-ask --silent &>/dev/null &";
	  }
	else
	  {
	    $command =
	      "/usr/bin/sudo /usr/sbin/cagefsctl --init --do-not-ask --silent &>/dev/null &";
	  }
	ob_start ();
	passthru ($command);
	ob_end_clean ();
	
      }

    if (($isAction["action"] == "init") || ($isAction["action"] == "reinit")
	|| (isset ($_POST["init_action"])))
      {
	$ovars["CAGEFS_NORERESH_INIT"] =
	  "refresh_executor = new PeriodicalExecuter(refresh_timer, 1);";
	$ovars["CAGEFS_RESULT_INIT"] =
	  "<div><b>Process of skeleton creation</b>  <span><img src=\"/images/modules/plesk-cagefs/LoadingProgressBar.gif\"></span></div><div id=\"prc_bar\">&nbsp;</div>".
	  "<div style=\"overflow: auto; width: 100%; height: 400px; border: 1px solid #000000;\"  name=\"cagefsiframe\" ".
	  " id=\"cagefsiframe\"></div>";
      }
    else
      {
	if (($isAction["action"] == "update"))
	  {
	    $ovars["CAGEFS_RESULT_INIT"] =
	      "<b>Go to Update tab, because update not ended yet</b>";
	  }
	else
	  {
	    $ovars["CAGEFS_RESULT_INIT"] =
	      "";
	    if (checkForSkeleteon ())
	      {
		$tmpInit = "Start Re-Init Now";
		$ovars["CAGEFS_BACK"]="<br/><br><input type=\"button\" name=\"back_action\" id=\"back_action\" value=\"Continue...\" />";
	      }
	    else
	      {
		$tmpInit = "Start Init Now";
	      }
	    $ovars["CAGEFS_BUTTON_INIT"] = "<br />".
	      "<br />".
	      "<form id=\"form1\" name=\"form1\" method=\"post\" action=\"\">".
	      " <div>".
	      "  <input type=\"hidden\" name=\"init_action\" id=\"init_action\" value=\"init_action\" />".
	      "  <input type=\"submit\" name=\"init_button\" value=\"        ".
	      $tmpInit."        \" />"." </div>"."</form>";

	    if (file_exists (CAGEFS_RESULTFILE))
	      {
		$ovars["CAGEFS_RESULT_INIT"].=
		  "<div><br/><br/><b>CageFS was initialized. See bellow for more information.</b> <a href=\"/modules/plesk-cagefs/fulllog.php?".PROTECT_URL."\" target=\"_blank\">Download full log file</a></div>".
		  "<div style=\"overflow: auto; width: 100%; height: 400px; border: 1px solid #000000;\"  name=\"cagefsiframe\" ".
		  " id=\"cagefsiframe\">";
		$lines = file (CAGEFS_RESULTFILE);
		$cnt = count ($lines);
		$number = $cnt - 100;
		if($number<0) $number = 0;
		for ($i = $number; $i < $cnt; $i++)
		  {
		    $ovars["CAGEFS_RESULT_INIT"].= "<p>".$lines[$i]."</p>";
		  }
		$ovars["CAGEFS_RESULT_INIT"].= "</div>";
		
	      }
	  }
      }

    return $ovars;
  }

}
