<?php
/**
 * Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
 *
 * Licensed under CLOUD LINUX LICENSE AGREEMENT
 * http://cloudlinux.com/docs/LICENSE.TXT
 */
require_once('modules/pm.php');

$forgery_protection_token_val = '';
if (method_exists('Session', 'get')) {
    if ( method_exists(Session::get(), 'panel') ){
        $forgery_protection_token_val = Session::get()->panel()->forgeryProtectionToken;  // for Plesk 12
    } else {
        $forgery_protection_token_val = Session::get()->getParam(Session_Param::FORGERY_PROTECTION_TOKEN); // for Plesk 11.5
    }
} else {
    $forgery_protection_token_val = $GLOBALS['session']->getParam(SPN_FORGERY_PROTECTION_TOKEN); // for Plesk 11.0
}

define('PROTECT_URL_KEY', 'forgery_protection_token');
define('PROTECT_URL_VAL', $forgery_protection_token_val);
define('PROTECT_URL', PROTECT_URL_KEY.'='.PROTECT_URL_VAL);
