<?php
/**
 * Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
 *
 * Licensed under CLOUD LINUX LICENSE AGREEMENT
 * http://cloudlinux.com/docs/LICENSE.TXT
 */
require_once ('modules/pm.php');
require_once ('modules/plesk-cagefs/config.php');
require_once ('modules/plesk-cagefs/options.php');
require_once ('modules/plesk-cagefs/init.php');
require_once ('modules/plesk-cagefs/update.php');
require_once ('modules/plesk-cagefs/manage.php');

class ModuleForm extends pm_Form
{

  private $_activeTab = 'home';
  private $_allowedTabs = array ('init', 'manage', 'update');
  private $_action;
  
  public function setActiveTab ($tabId)
  {
    if (in_array ($tabId, $this->_allowedTabs))
      {
	$this->_activeTab = $tabId;
      }
  }

  public function setAction ($actId)
  {
    $this->_action = $actId;
  }
  
  public function define ()
  {
    if (trim ($this->_action) == "")
      $this->addTemplates (array ('main' => 'main.tpl',
				  'form' =>'form.tpl',
				  'cagefs-module' => "modules/plesk-cagefs/{$this->_activeTab}.tpl",));
    else
      $this->addTemplates (array ('main' => 'main.tpl',
				  'form' => 'form.tpl',
				  'cagefs-module' => "modules/plesk-cagefs/{$this->_action}.tpl",));

    parent::define ();
  }


  public function assign ()
  {
    $tabs = new ScreenTabs ($this->_activeTab);
    $tabs->addScreenTab ('init', 'Init/Reinit', '?tab=init&'.PROTECT_URL);
    if(checkForSkeleteon()){
    	$tabs->addScreenTab ('manage', 'Manage Users', '?tab=manage&'.PROTECT_URL);
    	$tabs->addScreenTab ('update', 'Update', '?tab=update&'.PROTECT_URL);
    }

    $vars = array (/*'SCREEN_TABS' => $tabs->get ()*/);

    switch ($this->_activeTab)
      {
      case 'update':
	$upd = new UpdatePage ($this);
	$vars = $upd->getResult ($vars);
	break;
      case 'manage':
	$mng = new ManagePage ($this);
	$vars = $mng->getResult ($vars);
	break;
      case 'init':
	$init = new InitPage ($this);
	$vars = $init->getResult ($vars);
	break;
      default:

      }
    $vars['PROTECT_URL'] = PROTECT_URL;
    $this->addVars ($vars);
    parent::assign ();
  }

  public function parse ()
  {
    //parent::parse('FORM', 'lve-module');
    //parent::parse('BODY', 'form');
    parent::parse ('BODY', 'cagefs-module');
    parent::parse ('DOCUMENT', 'main');
  }
}
