#!/usr/bin/php -n
<?php

/**
 * Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
 *
 * Licensed under CLOUD LINUX LICENSE AGREEMENT
 * http://cloudlinux.com/docs/LICENSE.TXT
 */

    /*
     * Title: LVEManager Module.
     * Version: 1.1.0 (04/Nov/2011)
     * Author: Krishtopin Anton. AKrishtopin@cloudlinux.com
     * Site: http://CloudLinux.com
    */

set_time_limit(0);
error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);
ini_set('display_errors', 0);

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        $RequestString = fread(STDIN, $_SERVER['CONTENT_LENGTH']);
} elseif ($_SERVER['REQUEST_METHOD'] == 'GET') {
        $RequestString = $_SERVER['QUERY_STRING'];
}

$RequestString = urldecode($RequestString);

// Tmp Logger
//$file = fopen('/usr/local/ispmgr/addon/test.log',"a+");
//fwrite($file,PHP_EOL.$RequestString);
//fclose($file);

//$RequestString = 'func=cagefs.toggle&plid=';

// Include Commands Class
include_once('cagefs/Cagefs.class.php');

$Cagefs = new CageFS();
    
if ($Cagefs->CheckKernel()) {
    
    if (strstr($RequestString, 'func=cagefs.main')) {
        $Cagefs->ShowMain();
        $Cagefs->GetResult();
    }
    
    if (strstr($RequestString, 'func=cagefs.toggle')) {
        $Cagefs->ToggleMode();
        $Cagefs->GetResult();
    }
    
    if (strstr($RequestString, 'func=cagefs.enable-all')) {
        $Cagefs->EnableAll();
        $Cagefs->GetResult();
    }
    
    if (strstr($RequestString, 'func=cagefs.disable-all')) {
        $Cagefs->DisableAll();
        $Cagefs->GetResult();
    }
    
    if (strstr($RequestString, 'func=cagefs.status')) {
        $Cagefs->CageFSChangeStatus();
        $Cagefs->GetResult();
    }
    
    if (strstr($RequestString, 'func=cagefs.update_start')) {
        $Cagefs->CageFSUpdateStart();
        $Cagefs->GetResult();
    }
    
    if (strstr($RequestString, 'func=cagefs.update_progress')) {
        $Cagefs->CageFSUpdateProgress();
        $Cagefs->GetResult();
    }
    
    if (strstr($RequestString, 'func=cagefs.update_done')) {
        $Cagefs->CageFSUpdateDone();
        $Cagefs->GetResult();
    }
    
    if (strstr($RequestString, 'func=cagefs.init_start')) {
        $Cagefs->CageFSInitStart();
        $Cagefs->GetResult();
    }
    
    if (strstr($RequestString, 'func=cagefs.init_progress')) {
        $Cagefs->CageFSInitProgress();
        $Cagefs->GetResult();
    }
    
    if (strstr($RequestString, 'func=cagefs.init_done')) {
        $Cagefs->CageFSInitDone();
        $Cagefs->GetResult();
    }
    
} else {
    $Cagefs->GetResult();
}