<?php
/**
 * Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
 *
 * Licensed under CLOUD LINUX LICENSE AGREEMENT
 * http://cloudlinux.com/docs/LICENSE.TXT
 */

#Title: CloudLinux CageFS manager.                                                                                                                                
#Version: 1.0.1 (13/Jan/2011)                                                                                                                                
#Author: Anton Krishtopin (AKrishtopin@Cloudlinux.com)                                                                                                        
#Site: http://cloudLinux.com 

class Plugin_Cagefs extends Plugin {

    protected $_sw_menu_icon_small = '/plugins/images/cagefs/cagefs-16x16.png';
    
    protected $_sw_menu_icon_large = '/plugins/images/cagefs/cagefs-32x32.png';

  protected function _init() {
   
  }

  public function updateNodeworxMenu( IWorxMenuManager $MenuMan ) {
    try {
      if( IW::NW()->getWorkingUser()->getMenuStyle() === User::MENU_BIG ) {
        $icon = $this->_sw_menu_icon_large;
      } else {
        $icon = $this->_sw_menu_icon_small;
      }
    } catch( IWorx_Exception_NotLoggedIn $e ) {
      $icon = $this->_sw_menu_icon_small;
    }
    
    $new_data = array( 'text'   => 'СageFS',
                       'url'    => '/nodeworx/cagefs',
                       'img'  => $icon,
                       'disabled_for_reseller' => '1');
    $MenuMan->addMenuItemAfter( 'iw-menu-home', 'cagefs', $new_data );
  }
}
