<?php
/**
 * Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
 *
 * Licensed under CLOUD LINUX LICENSE AGREEMENT
 * http://cloudlinux.com/docs/LICENSE.TXT
 */

#Title: CloudLinux CageFS manager.                                                                                                                                
#Version: 1.0.1 (13/Jan/2011)                                                                                                                                
#Author: Anton Krishtopin (AKrishtopin@Cloudlinux.com)                                                                                                        
#Site: http://cloudLinux.com 

    define ("CAGEFS_SKELETON", "/usr/share/cagefs-skeleton/bin");
    define ("CAGEFS_RESULTFILE", "/var/log/cagefs-update.log");
    define ("CAGEFS_RESULTFILEUPD", "/var/log/cagefs-update.log");

    function CommandExecute($command,$result = true) {
        if ($result) {
            ob_start();
            passthru($command);
            $return = ob_get_contents();
            ob_end_clean();
            return explode(PHP_EOL,$return);
        } else {
            passthru($command);
            return true;
        }
    }

    function ShellExecute($command,$result = true) {
        if ($result) {
            ob_start();
            passthru($command);
            $return = ob_get_contents();
            ob_end_clean();
            return $return;
        } else {
            passthru($command);
            return true;
        }
    }
    
    function CheckKernel() {
        if (strstr(ShellExecute('/usr/bin/sudo /usr/sbin/cagefsctl --check-kernel-version'),'supported')) {
            return false;
        } else 
            return true;
    }
    
    function CheckCagefsCtlExists() {
        $result = CommandExecute('/usr/bin/sudo ps aux | grep cagefsctl');
        $action = 'none';
        for ($i = 0; $i < count($result); $i++) {
            if (strstr($result[$i], "--init") !== false) {
                $action = "init";
            }
            if (strstr($result[$i], "--reinit") !== false) {
                $action = "init";
        	}
            if (strstr($result[$i], "--update") !== false) {
                $action = "update";
        	}
        }
        return $action;
    }

    function CheckSkeleteon () {
        if ( file_exists(CAGEFS_SKELETON) ) {
            if (is_dir (CAGEFS_SKELETON)) {
                return true;
            }
        }
        return false;
    }

    function CheckCagefsMode() {
        $result = CommandExecute('/usr/bin/sudo /usr/sbin/cagefsctl --display-user-mode');
        
        if ( strstr($result[0],"CageFS is disabled") !== FALSE) {
            return false;
        } else {
            if ( strstr($result[0],"Mode: Enable All") !== FALSE) {
                $res['mode'] = 'Enabled by default';
                $res['change'] = 'disable';
                $res['status'] = 'enable all';
            } else {
                $res['mode'] = 'Disabled by default';
                $res['change'] = 'enable';
                $res['status'] = 'disable all';
            }
        }
        return $res;
    }

    function ChangeCageFSStatus($action) {
        if ('disable' == $action) {
            CommandExecute('/usr/bin/sudo /usr/sbin/cagefsctl --disable-cagefs',false);
        } else {
            CommandExecute('/usr/bin/sudo /usr/sbin/cagefsctl --enable-cagefs',false);
        }
    }

    function ChangeCageFSMode() {
        CommandExecute('/usr/bin/sudo /usr/sbin/cagefsctl --toggle-mode',false);
    }

    function ChangeUserMode($mode, $users) {
        if (!empty($users)) {
            $users = explode('|',$users);
            switch ($mode) {
            	case 'enable':
			$ul = "";
            		foreach ($users as $item) {
			 	if(trim($item)!=""){
					$ul.=$item." ";
				}    
            		}
			if(trim($ul)!=""){
				CommandExecute('/usr/bin/sudo /usr/sbin/cagefsctl --enable '.trim($ul),false);
			}
        		break;
            	case 'disable':
			$ul = "";
            		foreach ($users as $item) {
            		    	if(trim($item)!=""){
					$ul.=$item." ";
				}
            		}
			if(trim($ul)!=""){
				CommandExecute('/usr/bin/sudo /usr/sbin/cagefsctl --disable '.trim($ul),false);
			}
        		break;
            }
        }
    }

    function GetCagefsEnabledList() {
        $result = CommandExecute('/usr/bin/sudo /usr/sbin/cagefsctl --list-enabled');
        unset($result[count($result)-1],$result[count($result)-1],$result[0]);
//            $result = ClearSystemUsers($result); // Temp action remove after CageFS update
        asort($result);
//        $result[]='/usr/sbin/cagefsctl --list-enabled';
        return $result;
    }

    function GetCagefsDisabledList() {
        $result = CommandExecute('/usr/bin/sudo /usr/sbin/cagefsctl --list-disabled');
        unset($result[count($result)-1],$result[count($result)-1],$result[0]);
//            $result = ClearSystemUsers($result); // Temp action remove after CageFS update
        asort($result);
//        $result[]='/usr/sbin/cagefsctl --list-enabled';
        return $result;
    }

        
    function InitCageFS() {
        if ('status' == ($_GET['action'])) {
            if ('init' == CheckCagefsCtlExists()) {
                return false;
            } else {
                return true;
            }
        }
        
        if (empty($_GET) && 'none' == CheckCagefsCtlExists()) {
    	  	$command = "/usr/bin/sudo /usr/sbin/cagefsctl --init --do-not-ask --silent &>/dev/null &";
    	  	CommandExecute($command,true);
        }
        
        if ('none' == CheckCagefsCtlExists()) {
            if (file_exists (CAGEFS_RESULTFILE)) {
                $content = file(CAGEFS_RESULTFILE,FILE_SKIP_EMPTY_LINES);
                if (count($content) > 100) {
                    $Out = '...<br />...<br />...<br />';
                    for ($i = (count($content)-100); $i < (count($content)-1); $i++) {
                        $Out .= $i.'. '.$content[$i].'<br />';
                    }
                } else {
                    foreach ($content as $key => $value) {
                        $Out .= $key.'. '.$value.'<br />';
                    }
                }
                $Out .= '<br /><b>Init complete</b>';
                return $Out;
            }
        }
        
        if ('init' == CheckCagefsCtlExists()) {
            if (file_exists (CAGEFS_RESULTFILE)) {
                $content = file(CAGEFS_RESULTFILE,FILE_SKIP_EMPTY_LINES);
                if (count($content) > 100) {
                    $Out = '...<br />...<br />...<br />';
                    for ($i = (count($content)-100); $i < (count($content)-1); $i++) {
                        $Out .= $i.'. '.$content[$i].'<br />';
                    }
                } else {
                    foreach ($content as $key => $value) {
                        $Out .= $key.'. '.$value.'<br />';
                    }
                }
                return $Out;
            }
        }
        return null;
    }
    
    
        
    function UpdateCageFS() {
        if (!CheckSkeleteon()) {
            return false;
        }
        
        if ('status' == ($_GET['action'])) {
            if ('update' == CheckCagefsCtlExists()) {
                return false;
            } else {
                return true;
            }
        }
        
        if (empty($_GET) && 'none' == CheckCagefsCtlExists()) {
    	  	$command = "/usr/bin/sudo /usr/sbin/cagefsctl --update --do-not-ask --silent &>/dev/null &";
    	  	CommandExecute($command,true);
        }
        
        if ('none' == CheckCagefsCtlExists()) {
            if (file_exists (CAGEFS_RESULTFILEUPD)) {
                $content = file(CAGEFS_RESULTFILEUPD,FILE_SKIP_EMPTY_LINES);
                if (count($content) > 100) {
                    $Out = '...<br />...<br />...<br />';
                    for ($i = (count($content)-100); $i < (count($content)-1); $i++) {
                        $Out .= $i.'. '.$content[$i].'<br />';
                    }
                } else {
                    foreach ($content as $key => $value) {
                        $Out .= $key.'. '.$value.'<br />';
                    }
                }
                $Out .= '<br /><b>Update complete</b>';
                return $Out;
            }
        }
        
        if ('update' == CheckCagefsCtlExists()) {
            if (file_exists (CAGEFS_RESULTFILEUPD)) {
                $content = file(CAGEFS_RESULTFILEUPD,FILE_SKIP_EMPTY_LINES);
                if (count($content) > 100) {
                    $Out = '...<br />...<br />...<br />';
                    for ($i = (count($content)-100); $i < (count($content)-1); $i++) {
                        $Out .= $i.'. '.$content[$i].'<br />';
                    }
                } else {
                    foreach ($content as $key => $value) {
                        $Out .= $key.'. '.$value.'<br />';
                    }
                }
                return $Out;
            }
        }
        return null;
    }

    // Temp function
    function ClearSystemUsers($users = array()) {
        $return = array();
        foreach ($users as $key => $item) {
            if ( (!strstr($item,'cpanel')) && ('mailman' != $item) && ('nfsnobody' != $item) ) {
            	$return[] = $item;
            }
        }
        return $return;
    }
?>